/*
 * Decompiled with CFR 0.152.
 */
package unity.parser;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceField;
import unity.jdbc.UnityDriver;
import unity.mapping.DatabaseMapping;
import unity.mapping.GlobalFunction;
import unity.parser.ASTAs;
import unity.parser.ASTAscToken;
import unity.parser.ASTBoolean;
import unity.parser.ASTCase;
import unity.parser.ASTCaseElse;
import unity.parser.ASTCaseWhen;
import unity.parser.ASTCop;
import unity.parser.ASTDefault;
import unity.parser.ASTDscToken;
import unity.parser.ASTExists;
import unity.parser.ASTExprList;
import unity.parser.ASTFrom;
import unity.parser.ASTFunction;
import unity.parser.ASTGroupby;
import unity.parser.ASTHaving;
import unity.parser.ASTInteger;
import unity.parser.ASTInterval;
import unity.parser.ASTJoinExpr;
import unity.parser.ASTMyID;
import unity.parser.ASTNull;
import unity.parser.ASTOn;
import unity.parser.ASTOrderby;
import unity.parser.ASTParam;
import unity.parser.ASTReal;
import unity.parser.ASTSQLIS;
import unity.parser.ASTSQLPattern;
import unity.parser.ASTSelect;
import unity.parser.ASTString;
import unity.parser.ASTSubquery;
import unity.parser.ASTUnary;
import unity.parser.ASTWhere;
import unity.parser.PTreeBuilderValidater;
import unity.parser.SimpleNode;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.LQCaseExpr;
import unity.query.LQCondNode;
import unity.query.LQDupElimNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQIntervalExpr;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.LQOrderByNode;
import unity.query.LQProductNode;
import unity.query.LQProjNode;
import unity.query.LQRowNode;
import unity.query.LQSelNode;
import unity.query.LQSubQueryNode;
import unity.query.LQTree;
import unity.query.LQTreeConstants;
import unity.query.SubQuery;
import unity.util.StringFunc;

public class LQTreeBuilder
implements LQTreeConstants {
    private ArrayList<LQJoinNode> joinList;
    private SubQuery subQuery;
    private GlobalSchema gs;

    public LQTreeBuilder() {
    }

    public LQTreeBuilder(SubQuery subQuery, GlobalSchema globalSchema) {
        this.subQuery = subQuery;
        this.gs = globalSchema;
    }

    public LQTree BuildLQTree(SubQuery subQuery, SimpleNode simpleNode, GlobalSchema globalSchema, boolean bl) throws SQLException {
        LQNode lQNode;
        Object object;
        Object object2;
        this.subQuery = subQuery;
        this.gs = globalSchema;
        Object object3 = null;
        Object object4 = null;
        SimpleNode simpleNode2 = null;
        SimpleNode simpleNode3 = null;
        SimpleNode simpleNode4 = null;
        SimpleNode simpleNode5 = null;
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            object2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (object2 instanceof ASTSelect) {
                simpleNode5 = object2;
                continue;
            }
            if (object2 instanceof ASTWhere) {
                simpleNode4 = object2;
                continue;
            }
            if (object2 instanceof ASTOrderby) {
                simpleNode3 = object2;
                continue;
            }
            if (object2 instanceof ASTGroupby) {
                simpleNode2 = object2;
                continue;
            }
            if (object2 instanceof ASTHaving) {
                object4 = object2;
                continue;
            }
            if (!(object2 instanceof ASTFrom)) continue;
            object3 = object2;
        }
        LQNode lQNode2 = null;
        this.joinList = new ArrayList();
        if (object3 != null) {
            this.buildTableNodes(this.gs, (SimpleNode)object3, null);
        }
        object2 = null;
        object2 = simpleNode2 != null || object4 != null ? this.buildGroupByNode(simpleNode2, (SimpleNode)object4, subQuery.getFieldRefs()) : new LQGroupByNode();
        Object object5 = this.buildProjectionNode(simpleNode5, (LQGroupByNode)object2);
        LQProjNode lQProjNode = object5;
        if (!((LQGroupByNode)object2).isEmpty()) {
            object = ((LQNode)object2).getParent() == null ? object2 : ((LQNode)object2).getParent();
            ((LQNode)object).setParent((LQNode)object5);
            ((LQNode)object5).addChild((LQNode)object);
        }
        if (simpleNode5 != null && ((ASTSelect)simpleNode5).getDistinct()) {
            object = new LQDupElimNode();
            ((LQNode)object).addChild((LQNode)object5);
            ((LQNode)object5).setParent((LQNode)object);
            object5 = object;
        }
        object = new LQTree((LQNode)object5);
        if (((LQNode)object5).getNumChildren() > 0) {
            lQNode2 = object5;
            while (lQNode2.getNumChildren() > 0) {
                lQNode2 = lQNode2.getChild(0);
            }
        } else {
            lQNode2 = object5;
        }
        if (simpleNode4 != null && (lQNode = this.buildConditionNodes((SimpleNode)simpleNode4.jjtGetChild(0), lQNode2, subQuery.getFieldRefs())) != null) {
            lQNode2 = lQNode;
        }
        this.connectTableNodes(lQNode2);
        ((LQTree)object).setJoinList(this.joinList);
        if (simpleNode3 != null) {
            lQNode = this.buildOrderByNode(simpleNode3, lQProjNode, (LQNode)object2);
            if (!((LQOrderByNode)lQNode).getProjectLast()) {
                LQNode lQNode3 = ((LQTree)object).getRoot();
                lQNode3.setParent(lQNode);
                lQNode.addChild(lQNode3);
                ((LQTree)object).setRoot(lQNode);
            } else {
                LQNode lQNode4 = ((LQTree)object).getRoot();
                LQNode lQNode5 = lQNode4.getChild(0);
                lQNode5.setParent(lQNode);
                lQNode.addChild(lQNode5);
                lQNode4.setChild(0, lQNode);
                lQNode.setParent(lQNode4);
            }
        }
        LQTreeBuilder.finalValidate(this.subQuery);
        return object;
    }

    private static void finalValidate(SubQuery subQuery) {
        HashMap<String, GQTableRef> hashMap = subQuery.getTableRefs();
        Iterator<Map.Entry<String, GQTableRef>> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            AnnotatedSourceKey annotatedSourceKey;
            LQProjNode lQProjNode;
            GQTableRef gQTableRef = iterator.next().getValue();
            LQNode lQNode = gQTableRef.getNode();
            if (!(lQNode instanceof LQProjNode) || (lQProjNode = (LQProjNode)gQTableRef.getNode()).getExpressions().size() != 0 || (annotatedSourceKey = (AnnotatedSourceKey)gQTableRef.getTable().getPrimaryKey()) == null) continue;
            ArrayList<SourceField> arrayList = annotatedSourceKey.getFields();
            for (int i = 0; i < arrayList.size(); ++i) {
                AnnotatedSourceField annotatedSourceField = (AnnotatedSourceField)arrayList.get(i);
                LQExprNode lQExprNode = new LQExprNode();
                String string = annotatedSourceField.getColumnName();
                GQFieldRef gQFieldRef = new GQFieldRef(annotatedSourceField, string, gQTableRef);
                lQExprNode.setType(100);
                lQExprNode.setContent(gQFieldRef);
                ((LQProjNode)lQNode).addExpression(lQExprNode);
            }
        }
    }

    private LQOrderByNode buildOrderByNode(SimpleNode simpleNode, LQProjNode lQProjNode, LQNode lQNode) throws SQLException {
        LQOrderByNode lQOrderByNode = new LQOrderByNode();
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            Object object;
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            LQExprNode lQExprNode = this.BuildExpressionNode(4, simpleNode2, lQNode, this.subQuery.getFieldRefs());
            if (!lQOrderByNode.getProjectLast() && !lQProjNode.hasExpression(lQExprNode.toString())) {
                object = LQNode.getAllExprNodes(lQExprNode);
                for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                    GQFieldRef gQFieldRef;
                    LQExprNode lQExprNode2 = (LQExprNode)((ArrayList)object).get(j);
                    if (!(lQExprNode2.getContent() instanceof GQFieldRef) || lQProjNode.hasExpression((gQFieldRef = (GQFieldRef)lQExprNode2.getContent()).getName())) continue;
                    LQNode lQNode2 = lQProjNode.getChild();
                    ArrayList<LQExprNode> arrayList = LQNode.getAllExprNodes(lQNode2);
                    if (arrayList.contains(lQExprNode2)) {
                        lQOrderByNode.setProjectLast(true);
                        continue;
                    }
                    boolean bl = false;
                    for (int k = 0; k < arrayList.size(); ++k) {
                        GQFieldRef gQFieldRef2;
                        LQExprNode lQExprNode3 = arrayList.get(k);
                        if (lQExprNode3.toString().equalsIgnoreCase(lQExprNode.toString())) {
                            bl = true;
                            break;
                        }
                        if (!(lQExprNode3.getContent() instanceof GQFieldRef) || (gQFieldRef2 = (GQFieldRef)lQExprNode3.getContent()) != lQExprNode2.getContent()) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.InvalidOrderByField") + lQExprNode.toString());
                    }
                    lQOrderByNode.setProjectLast(true);
                }
            }
            if (++i >= simpleNode.jjtGetNumChildren()) {
                lQOrderByNode.addExpression(lQExprNode, "ASC");
                break;
            }
            object = (SimpleNode)simpleNode.jjtGetChild(i);
            if (object instanceof ASTDscToken) {
                lQOrderByNode.addExpression(lQExprNode, "DESC");
                continue;
            }
            if (object instanceof ASTAscToken) {
                lQOrderByNode.addExpression(lQExprNode, "ASC");
                continue;
            }
            lQOrderByNode.addExpression(lQExprNode, "ASC");
            --i;
        }
        return lQOrderByNode;
    }

    private LQGroupByNode buildGroupByNode(SimpleNode simpleNode, SimpleNode simpleNode2, HashMap<String, GQFieldRef> hashMap) throws SQLException {
        LQGroupByNode lQGroupByNode = new LQGroupByNode();
        if (simpleNode != null) {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                LQNode lQNode;
                SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (!(simpleNode3 instanceof ASTHaving)) {
                    lQNode = this.BuildExpressionNode(5, simpleNode3, null, this.subQuery.getFieldRefs());
                    lQGroupByNode.addGroupByExpression((LQExprNode)lQNode);
                    continue;
                }
                lQNode = this.buildHavingNode((SimpleNode)simpleNode3.jjtGetChild(0), lQGroupByNode, hashMap);
                lQGroupByNode.setParent(lQNode);
                lQNode.setParent(null);
                lQNode.addChild(lQGroupByNode);
            }
        }
        if (simpleNode2 != null) {
            LQSelNode lQSelNode = this.buildHavingNode((SimpleNode)simpleNode2.jjtGetChild(0), lQGroupByNode, hashMap);
            lQGroupByNode.setParent(lQSelNode);
            lQSelNode.setParent(null);
            lQSelNode.addChild(lQGroupByNode);
        }
        return lQGroupByNode;
    }

    private void addTableFieldsToProjectNode(LQProjNode lQProjNode, GQTableRef gQTableRef) {
        Object object;
        Serializable serializable;
        String string = gQTableRef.getName();
        AnnotatedSourceTable annotatedSourceTable = gQTableRef.getTable();
        HashMap<String, GQFieldRef> hashMap = this.subQuery.getFieldRefs();
        HashMap<String, SourceField> hashMap2 = annotatedSourceTable.getSourceFields();
        Iterator<SourceField> iterator = annotatedSourceTable.fieldIterator();
        ArrayList<LQExprNode> arrayList = new ArrayList<LQExprNode>(hashMap2.size());
        int n = 0;
        while (iterator.hasNext()) {
            serializable = (AnnotatedSourceField)iterator.next();
            object = (String)((SourceField)((Object)serializable)).getProperty("output");
            if (object != null && ((String)object).equalsIgnoreCase("false")) continue;
            LQExprNode lQExprNode = new LQExprNode();
            lQExprNode.setType(100);
            arrayList.add(lQExprNode);
            String string2 = StringFunc.idHashKey(new String[]{string, ((SourceField)((Object)serializable)).getColumnName()});
            GQFieldRef gQFieldRef = hashMap.get(string2);
            lQExprNode.setContent(gQFieldRef);
            if (!((SourceField)((Object)serializable)).getColumnName().equals("*")) continue;
            lQExprNode.setContent("*");
        }
        serializable = gQTableRef.getNode();
        object = null;
        if (!(serializable instanceof LQSubQueryNode)) {
            object = (LQProjNode)serializable;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            lQProjNode.addExpression((LQExprNode)arrayList.get(n));
            if (object == null) continue;
            ((LQProjNode)object).addNoDupExpression((LQExprNode)arrayList.get(n));
        }
    }

    private void processStarIdentifier(LQProjNode lQProjNode, SimpleNode simpleNode) throws SQLException {
        String string = simpleNode.toString().substring(12);
        GQFieldRef gQFieldRef = (GQFieldRef)simpleNode.getReference();
        if (gQFieldRef == null) {
            throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.InvalidReference") + string);
        }
        Object object = gQFieldRef.getReference();
        if (object instanceof HashMap) {
            HashMap hashMap = (HashMap)object;
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                GQTableRef gQTableRef = (GQTableRef)iterator.next().getValue();
                this.addTableFieldsToProjectNode(lQProjNode, gQTableRef);
            }
        } else {
            if (object == null) {
                object = gQFieldRef.getTable();
            }
            this.addTableFieldsToProjectNode(lQProjNode, (GQTableRef)object);
        }
    }

    private LQProjNode buildProjectionNode(SimpleNode simpleNode, LQGroupByNode lQGroupByNode) throws SQLException {
        LQProjNode lQProjNode = new LQProjNode();
        if (((ASTSelect)simpleNode).getAll()) {
            HashMap<String, GQTableRef> hashMap = this.subQuery.getTableRefs();
            for (String string : hashMap.keySet()) {
                GQTableRef gQTableRef = hashMap.get(string);
                this.addTableFieldsToProjectNode(lQProjNode, gQTableRef);
            }
            if (lQProjNode.getNumColumns() == 0) {
                throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorNoOutputFields"));
            }
        } else {
            LQExprNode lQExprNode = null;
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
            HashMap<String, GQFieldRef> hashMap = this.subQuery.getFieldRefs();
            for (int i = 1; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (simpleNode3 instanceof ASTAs) {
                    simpleNode.jjtRemoveChild(i - 1);
                    simpleNode2.jjtSetParent(simpleNode3);
                    simpleNode3.InsertChild(0, simpleNode2);
                    lQExprNode = this.BuildExpressionNode(1, simpleNode3, lQGroupByNode, hashMap);
                    simpleNode2 = i < simpleNode.jjtGetNumChildren() ? (SimpleNode)simpleNode.jjtGetChild(i) : null;
                } else {
                    String string = simpleNode2.toString();
                    if (string.indexOf("*") > 0 && !(simpleNode2 instanceof ASTFunction)) {
                        this.processStarIdentifier(lQProjNode, simpleNode2);
                        lQExprNode = null;
                    } else {
                        lQExprNode = this.BuildExpressionNode(1, simpleNode2, lQGroupByNode, hashMap);
                        lQExprNode.setParent(lQProjNode);
                    }
                    simpleNode2 = simpleNode3;
                }
                if (lQExprNode == null) continue;
                lQProjNode.addExpression(lQExprNode);
            }
            if (simpleNode2 != null) {
                String string = simpleNode2.toString();
                if (string.indexOf("*") > 0 && !(simpleNode2 instanceof ASTFunction)) {
                    this.processStarIdentifier(lQProjNode, simpleNode2);
                } else {
                    lQExprNode = this.BuildExpressionNode(1, simpleNode2, lQGroupByNode, hashMap);
                    lQExprNode.setParent(lQProjNode);
                    lQProjNode.addExpression(lQExprNode);
                }
            }
        }
        if (!lQGroupByNode.isEmpty()) {
            this.validateProjectionNode(lQProjNode, lQGroupByNode);
        }
        return lQProjNode;
    }

    private void validateProjectionNode(LQProjNode lQProjNode, LQGroupByNode lQGroupByNode) throws SQLException {
        ArrayList<LQExprNode> arrayList = lQProjNode.getExpressions();
        for (int i = 0; i < arrayList.size(); ++i) {
            LQExprNode lQExprNode = arrayList.get(i);
            lQGroupByNode.validateField(lQExprNode);
        }
    }

    private static String getIdentifier(String string) {
        return string.substring(12);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LQExprNode BuildExpressionNode(int n, SimpleNode simpleNode, LQNode lQNode, HashMap<String, GQFieldRef> hashMap) throws SQLException {
        LQExprNode lQExprNode = new LQExprNode();
        String string = simpleNode.toString();
        if (simpleNode instanceof ASTMyID) {
            lQExprNode.setType(100);
            String string2 = LQTreeBuilder.getIdentifier(string);
            GQFieldRef gQFieldRef = (GQFieldRef)simpleNode.getReference();
            if (string2.equals("*")) {
                lQExprNode.setContent("*");
                lQExprNode.setType(101);
                if (simpleNode.jjtGetParent().toString().toLowerCase().indexOf("count") >= 0) return lQExprNode;
                throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorUseStarNotWithAggCount") + simpleNode.jjtGetParent().toString());
            }
            if (gQFieldRef == null && (gQFieldRef = hashMap.get(string2 = string2.toLowerCase())) == null) {
                throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.InvalidReference") + string2);
            }
            Object object = gQFieldRef.getReference();
            if (object != null && object instanceof LQExprNode) {
                LQExprNode lQExprNode2 = (LQExprNode)object;
                return new LQExprNode(lQExprNode2);
            }
            lQExprNode.setContent(gQFieldRef);
            GQTableRef gQTableRef = gQFieldRef.getTable();
            if (gQTableRef == null) return lQExprNode;
            if (gQTableRef.isSubquery()) return lQExprNode;
            LQProjNode lQProjNode = (LQProjNode)gQTableRef.getNode();
            if (lQProjNode == null) return lQExprNode;
            lQProjNode.addNoDupExpression(lQExprNode);
            return lQExprNode;
        }
        if (simpleNode instanceof ASTAs) {
            Object object;
            if (n != 1) {
                throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorRenameAsOnlySelect"));
            }
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(1);
            if (!(simpleNode2 instanceof ASTMyID)) {
                throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorRenameAsOnRightSide"));
            }
            lQExprNode.setType(103);
            LQExprNode lQExprNode3 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(0), lQNode, hashMap);
            lQExprNode.addChild(lQExprNode3);
            LQExprNode lQExprNode4 = new LQExprNode();
            lQExprNode4.setType(100);
            String string3 = simpleNode.jjtGetChild(1).toString().substring(12);
            if (string3.equals("\"\"")) {
                if (lQExprNode3.getType() == 100) {
                    object = lQExprNode3.getContent();
                    string3 = object instanceof GQFieldRef ? ((GQFieldRef)object).getName() : "Field";
                }
                string3 = "\"\"";
            }
            lQExprNode4.setContent(string3);
            lQExprNode.addChild(lQExprNode4);
            object = hashMap.get(StringFunc.idHashKey(new String[]{string3}));
            if (object == null) return lQExprNode;
            ((GQFieldRef)object).setReference(lQExprNode3);
            return lQExprNode;
        }
        if (simpleNode instanceof ASTFunction) {
            Object object;
            ASTFunction aSTFunction = (ASTFunction)simpleNode;
            String string4 = aSTFunction.getName().toUpperCase();
            lQExprNode.setContent(string4);
            int n2 = simpleNode.jjtGetNumChildren();
            for (int i = 0; i < n2; ++i) {
                object = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(i), lQNode, hashMap);
                lQExprNode.addChild((LQNode)object);
            }
            if (string4.equalsIgnoreCase("NP")) {
                lQExprNode.setType(129);
                LQNode lQNode2 = lQExprNode.getChild(0);
                object = lQNode2.generateSQL();
                object = ((String)object).substring(1, ((String)object).length() - 1).toLowerCase();
                GQDatabaseRef gQDatabaseRef = this.subQuery.getDBRef((String)object);
                if (gQDatabaseRef == null) return lQExprNode;
                lQNode2.setReference(gQDatabaseRef);
                GQTableRef gQTableRef = this.subQuery.getTableRef(gQDatabaseRef);
                LQProjNode lQProjNode = (LQProjNode)gQTableRef.getNode();
                if (lQProjNode == null) return lQExprNode;
                lQProjNode.addNoDupExpression(lQExprNode);
                return lQExprNode;
            } else if (LQGroupByNode.isAggregateFunction(string4)) {
                lQExprNode.setType(125);
                String string5 = aSTFunction.getParam();
                if (string5 != null) {
                    if ((string5 = string5.toUpperCase()).equals("*")) {
                        if (!string4.equalsIgnoreCase("count")) throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorUseStarNotWithAggCount") + string4);
                        object = new LQExprNode();
                        ((LQNode)object).setContent("*");
                        ((LQNode)object).setType(101);
                        lQExprNode.addChild((LQNode)object);
                        ((LQNode)object).setParent(lQExprNode);
                        ((LQNode)object).setReference(lQNode);
                    } else if (string5.equals("DISTINCT")) {
                        lQExprNode.setType(124);
                        lQExprNode.setContent(lQExprNode.getContent() + " DISTINCT");
                    } else if (!string5.equals("ALL")) throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorInvalidFunctionSyntax") + string5);
                }
                if (n == 5) return lQExprNode;
                object = ((LQGroupByNode)lQNode).findAggregateFunction(lQExprNode);
                if (object == null) {
                    ((LQGroupByNode)lQNode).addAggregateFunction(lQExprNode);
                    object = lQExprNode;
                }
                lQExprNode = new LQExprNode();
                lQExprNode.setType(120);
                lQExprNode.setContent(object);
                return lQExprNode;
            } else {
                lQExprNode.setType(102);
                GlobalFunction globalFunction = DatabaseMapping.getFunction(string4, lQExprNode);
                lQExprNode.setReference(globalFunction);
            }
            return lQExprNode;
        }
        if (simpleNode instanceof ASTParam) {
            lQExprNode.setType(145);
            lQExprNode.setContent("?");
            GQFieldRef gQFieldRef = (GQFieldRef)simpleNode.getReference();
            lQExprNode.setReference(gQFieldRef);
            gQFieldRef.setReference(lQExprNode);
            return lQExprNode;
        }
        if (simpleNode instanceof ASTBoolean) {
            lQExprNode.setType(151);
            lQExprNode.setContent(new Boolean(((ASTBoolean)simpleNode).getValue()));
            return lQExprNode;
        }
        if (simpleNode instanceof ASTInteger || simpleNode instanceof ASTReal || simpleNode instanceof ASTString) {
            Date date;
            SimpleDateFormat simpleDateFormat;
            String string6 = string.substring(string.indexOf(":") + 1).trim();
            if (simpleNode instanceof ASTInteger) {
                try {
                    lQExprNode.setType(104);
                    lQExprNode.setContent(new Integer(string6));
                    return lQExprNode;
                }
                catch (Exception exception) {
                    lQExprNode.setType(150);
                    lQExprNode.setContent(new Long(string6));
                }
                return lQExprNode;
            }
            if (simpleNode instanceof ASTReal) {
                lQExprNode.setType(105);
                lQExprNode.setContent(new Double(string6));
                return lQExprNode;
            }
            boolean bl = false;
            String string7 = string6;
            if (string6.length() > 0 && string6.charAt(0) == '\'' && string6.endsWith("'")) {
                string7 = string6.substring(1).substring(0, string6.length() - 2);
            }
            lQExprNode.setReference(string7);
            try {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                date = simpleDateFormat.parse(string7);
                lQExprNode.setType(142);
                lQExprNode.setContent(date);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                try {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    date = simpleDateFormat.parse(string7);
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date);
                    if (gregorianCalendar.get(1) > 1900) {
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(13, 0);
                        lQExprNode.setType(140);
                        lQExprNode.setContent(gregorianCalendar.getTime());
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) {
                try {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                    date = simpleDateFormat.parse(string7);
                    lQExprNode.setType(141);
                    lQExprNode.setContent(date);
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) return lQExprNode;
            lQExprNode.setType(101);
            lQExprNode.setContent(string6);
            return lQExprNode;
        }
        if (simpleNode instanceof ASTSubquery) {
            SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(0);
            if (simpleNode3 instanceof ASTExprList) {
                ArrayList<LQExprNode> arrayList = new ArrayList<LQExprNode>();
                for (int i = 0; i < simpleNode3.jjtGetNumChildren(); ++i) {
                    LQExprNode lQExprNode5 = this.BuildExpressionNode(n, (SimpleNode)simpleNode3.jjtGetChild(i), lQNode, hashMap);
                    arrayList.add(lQExprNode5);
                }
                lQExprNode.setType(134);
                lQExprNode.setContent(arrayList);
                return lQExprNode;
            } else {
                PTreeBuilderValidater pTreeBuilderValidater = new PTreeBuilderValidater(this.gs, true);
                LQTreeBuilder lQTreeBuilder = new LQTreeBuilder();
                SubQuery subQuery = new SubQuery();
                subQuery.setParent(this.subQuery);
                pTreeBuilderValidater.ParseQuery(simpleNode, subQuery, true);
                LQTree lQTree = lQTreeBuilder.BuildLQTree(subQuery, simpleNode, this.gs, false);
                subQuery.setLogicalQueryTree(lQTree);
                lQExprNode.addChild(lQTree.getRoot());
                lQExprNode.setType(17);
                lQExprNode.setContent(subQuery);
            }
            return lQExprNode;
        } else if (simpleNode instanceof ASTSQLPattern) {
            String string8 = string.substring(string.indexOf(":") + 1).trim();
            lQExprNode.setType(117);
            lQExprNode.setContent(string8);
            return lQExprNode;
        } else if (simpleNode instanceof ASTUnary) {
            if (string.charAt(7) != '-') return lQExprNode;
            LQExprNode lQExprNode6 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(0), lQNode, hashMap);
            if (lQExprNode6.getType() == 104) {
                lQExprNode6.setContent((Integer)lQExprNode6.getContent() * -1);
                return lQExprNode6;
            }
            if (lQExprNode6.getType() == 150) {
                lQExprNode6.setContent((Long)lQExprNode6.getContent() * -1L);
                return lQExprNode6;
            }
            if (lQExprNode6.getType() == 105) {
                lQExprNode6.setContent((Double)lQExprNode6.getContent() * -1.0);
                return lQExprNode6;
            }
            LQExprNode lQExprNode7 = new LQExprNode();
            lQExprNode7.setType(104);
            lQExprNode7.setContent(new Integer(-1));
            lQExprNode.setType(126);
            lQExprNode.setContent("*");
            lQExprNode.addChild(lQExprNode6);
            lQExprNode.addChild(lQExprNode7);
            return lQExprNode;
        } else if (simpleNode instanceof ASTSQLIS) {
            String string9 = string.substring(string.indexOf(":") + 1).trim();
            lQExprNode.setType(130);
            lQExprNode.setContent(string9.toUpperCase());
            return lQExprNode;
        } else if (simpleNode instanceof ASTNull) {
            lQExprNode.setType(131);
            lQExprNode.setContent("NULL");
            return lQExprNode;
        } else if (simpleNode instanceof ASTDefault) {
            lQExprNode.setType(132);
            lQExprNode.setContent("DEFAULT");
            return lQExprNode;
        } else {
            if (simpleNode instanceof ASTInterval) {
                String string10;
                LQIntervalExpr lQIntervalExpr = new LQIntervalExpr();
                LQExprNode lQExprNode8 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(0), lQNode, hashMap);
                if (lQExprNode8.getType() == 141) {
                    string10 = simpleNode.jjtGetChild(0).toString();
                    lQExprNode8.setContent(string10.substring(string10.indexOf(":") + 1).trim());
                    lQExprNode8.setType(101);
                }
                lQIntervalExpr.setValueExpr(lQExprNode8);
                string10 = simpleNode.jjtGetChild(1).toString().substring(15);
                lQIntervalExpr.setIntervalType(string10);
                return lQIntervalExpr;
            }
            if (simpleNode instanceof ASTCase) {
                void var12_72;
                int n3;
                ArrayList<LQNode> arrayList;
                LQCaseExpr lQCaseExpr = new LQCaseExpr();
                lQCaseExpr.setType(133);
                lQCaseExpr.setContent("CASE");
                if (simpleNode.jjtGetChild(0) instanceof ASTCaseWhen || simpleNode.jjtGetChild(1) instanceof ASTCaseWhen) {
                    ArrayList<LQNode> arrayList2;
                    int n4;
                    if (simpleNode.jjtGetChild(0) instanceof ASTCaseWhen) {
                        lQCaseExpr.setSwitchExpr(null);
                        n4 = 0;
                    } else {
                        arrayList2 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(0), lQNode, hashMap);
                        lQCaseExpr.setSwitchExpr((LQExprNode)((Object)arrayList2));
                        n4 = 1;
                    }
                    arrayList2 = new ArrayList();
                    ArrayList<LQExprNode> arrayList3 = new ArrayList<LQExprNode>();
                    for (int i = n4; i < simpleNode.jjtGetNumChildren(); i += 2) {
                        void var12_67;
                        if (simpleNode.jjtGetChild(i) instanceof ASTCaseElse) {
                            LQExprNode lQExprNode9 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(i).jjtGetChild(0), lQNode, hashMap);
                            lQCaseExpr.setElseExpr(lQExprNode9);
                            break;
                        }
                        if (n4 == 1) {
                            LQExprNode lQExprNode10 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(i).jjtGetChild(0), lQNode, hashMap);
                        } else {
                            LQCondNode lQCondNode = this.buildConditionNode((SimpleNode)simpleNode.jjtGetChild(i).jjtGetChild(0), 207, lQNode, hashMap);
                        }
                        LQExprNode lQExprNode11 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(i + 1).jjtGetChild(0), lQNode, hashMap);
                        arrayList2.add((LQNode)var12_67);
                        arrayList3.add(lQExprNode11);
                    }
                    lQCaseExpr.setValues(arrayList3);
                    lQCaseExpr.setCases(arrayList2);
                    return lQCaseExpr;
                }
                SimpleNode simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(0);
                if (simpleNode4 instanceof ASTMyID) {
                    arrayList = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(0), lQNode, hashMap);
                    lQCaseExpr.setSwitchExpr((LQExprNode)((Object)arrayList));
                    n3 = 1;
                } else {
                    lQCaseExpr.setSwitchExpr(null);
                    n3 = 0;
                }
                arrayList = new ArrayList();
                ArrayList<LQExprNode> arrayList4 = new ArrayList<LQExprNode>();
                int n5 = n3;
                for (int i = 0; i < (simpleNode.jjtGetNumChildren() - n3) / 2; ++i) {
                    void var14_78;
                    if (n3 == 1) {
                        LQExprNode lQExprNode12 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild((int)var12_72++), lQNode, hashMap);
                    } else {
                        LQCondNode lQCondNode = this.buildConditionNode((SimpleNode)simpleNode.jjtGetChild((int)var12_72++), 207, lQNode, hashMap);
                    }
                    LQExprNode lQExprNode13 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild((int)var12_72++), lQNode, hashMap);
                    arrayList.add((LQNode)var14_78);
                    arrayList4.add(lQExprNode13);
                }
                if (var12_72 < simpleNode.jjtGetNumChildren()) {
                    LQExprNode lQExprNode14 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild((int)var12_72), lQNode, hashMap);
                    lQCaseExpr.setElseExpr(lQExprNode14);
                }
                lQCaseExpr.setValues(arrayList4);
                lQCaseExpr.setCases(arrayList);
                return lQCaseExpr;
            }
            LQExprNode lQExprNode15 = null;
            if (simpleNode.jjtGetNumChildren() <= 0) return lQExprNode15;
            LQExprNode lQExprNode16 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(0), lQNode, hashMap);
            int n6 = 1;
            while (n6 < simpleNode.jjtGetNumChildren()) {
                LQExprNode lQExprNode17 = this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(n6 + 1), lQNode, hashMap);
                lQExprNode15 = new LQExprNode();
                lQExprNode15.setType(126);
                String string11 = simpleNode.jjtGetChild(n6).toString();
                string11 = string11.substring(string11.indexOf(":") + 1).trim();
                lQExprNode15.setContent(string11);
                lQExprNode15.addChild(lQExprNode16);
                lQExprNode15.addChild(lQExprNode17);
                lQExprNode16 = lQExprNode15;
                n6 += 2;
            }
            return lQExprNode15;
        }
    }

    private LQNode buildTableNodes(GlobalSchema globalSchema, SimpleNode simpleNode, LQNode lQNode) throws SQLException {
        LQNode lQNode2 = null;
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            Object object;
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2 instanceof ASTMyID) {
                object = (GQTableRef)simpleNode2.getReference();
                lQNode2 = this.buildTableExprNode((GQTableRef)object);
                continue;
            }
            if (simpleNode2 instanceof ASTJoinExpr) {
                lQNode2 = this.buildTableNodes(globalSchema, simpleNode2, lQNode2);
                continue;
            }
            if (simpleNode2 instanceof ASTOn) {
                LQNode lQNode3;
                object = (SimpleNode)simpleNode2.jjtGetChild(0);
                LQNode lQNode4 = lQNode3 = this.buildJoinConditionNodes((SimpleNode)object, simpleNode);
                if (lQNode3 instanceof LQSelNode) {
                    lQNode4 = lQNode4.getChild(0);
                }
                lQNode4.addChild(lQNode);
                lQNode4.addChild(lQNode2);
                lQNode.setParent(lQNode4);
                lQNode2.setParent(lQNode4);
                this.joinList.add((LQJoinNode)lQNode4);
                lQNode2 = lQNode3;
                continue;
            }
            if (!(simpleNode2 instanceof ASTAs)) continue;
            simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
            object = (GQTableRef)simpleNode2.getReference();
            lQNode2 = this.buildTableExprNode((GQTableRef)object);
        }
        return lQNode2;
    }

    private LQNode buildTableExprNode(GQTableRef gQTableRef) {
        if (gQTableRef.isSubquery()) {
            return this.buildSubqueryNode(gQTableRef);
        }
        LQExprNode lQExprNode = new LQExprNode();
        lQExprNode.setType(6);
        lQExprNode.setContent(gQTableRef);
        lQExprNode.setReference(gQTableRef.getParentDB());
        LQProjNode lQProjNode = new LQProjNode();
        lQProjNode.addChild(lQExprNode);
        lQExprNode.setParent(lQProjNode);
        gQTableRef.setNode(lQProjNode);
        return lQProjNode;
    }

    private LQNode buildSubqueryNode(GQTableRef gQTableRef) {
        LQSubQueryNode lQSubQueryNode = new LQSubQueryNode();
        SubQuery subQuery = (SubQuery)gQTableRef.getReference();
        LQTree lQTree = subQuery.getLogicalQueryTree();
        lQSubQueryNode.setSq(subQuery);
        lQSubQueryNode.setContent(gQTableRef);
        gQTableRef.setNode(lQSubQueryNode);
        lQSubQueryNode.addChild(lQTree.getRoot());
        return lQSubQueryNode;
    }

    private LQNode buildJoinConditionNodes(SimpleNode simpleNode, SimpleNode simpleNode2) throws SQLException {
        Object object;
        LQJoinNode lQJoinNode = new LQJoinNode();
        String string = "";
        LQCondNode lQCondNode = null;
        if (this.isJoinCondition(simpleNode)) {
            lQCondNode = this.buildConditionNode(simpleNode, 207, null, this.subQuery.getFieldRefs());
            lQJoinNode.setCondition(lQCondNode);
            lQJoinNode.setContent(lQCondNode.toString());
        } else {
            lQCondNode = this.buildConditionNode(simpleNode, 207, null, this.subQuery.getFieldRefs());
            if (lQCondNode.containsOr() || lQCondNode.getType() == 112) {
                lQJoinNode.setJoinType(305);
                lQJoinNode.setCondition(lQCondNode);
            } else {
                object = null;
                LQCondNode lQCondNode2 = null;
                LQCondNode lQCondNode3 = lQCondNode;
                Stack<LQCondNode> stack = new Stack<LQCondNode>();
                stack.add(lQCondNode3);
                while (!stack.isEmpty()) {
                    lQCondNode3 = (LQCondNode)stack.pop();
                    if (lQCondNode3.getType() == 111) {
                        for (int i = 0; i < lQCondNode3.getNumChildren(); ++i) {
                            LQCondNode lQCondNode4;
                            LQCondNode lQCondNode5 = (LQCondNode)lQCondNode3.getChild(i);
                            if (lQCondNode5.getType() == 111) {
                                stack.push(lQCondNode5);
                                continue;
                            }
                            if (!lQCondNode5.isJoinCondition()) {
                                if (lQCondNode2 == null) {
                                    lQCondNode2 = lQCondNode5;
                                    lQCondNode5.setParent(null);
                                    continue;
                                }
                                lQCondNode4 = new LQCondNode();
                                lQCondNode4.setType(111);
                                lQCondNode4.setContent("AND");
                                lQCondNode4.addChild(lQCondNode2);
                                lQCondNode4.addChild(lQCondNode5);
                                lQCondNode2 = lQCondNode4;
                                lQCondNode5.setParent(lQCondNode4);
                                continue;
                            }
                            if (object == null) {
                                object = lQCondNode5;
                                lQCondNode5.setParent(null);
                                continue;
                            }
                            lQCondNode4 = new LQCondNode();
                            lQCondNode4.setType(111);
                            lQCondNode4.setContent("AND");
                            lQCondNode4.addChild((LQNode)object);
                            lQCondNode4.addChild(lQCondNode5);
                            object = lQCondNode4;
                            lQCondNode5.setParent(lQCondNode4);
                        }
                        continue;
                    }
                    if (lQCondNode3.getType() != 110) continue;
                    throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorUseOrJoinClause"));
                }
                if (object == null) {
                    object = lQCondNode;
                    if (lQCondNode2 == null) {
                        lQJoinNode.setCondition((LQCondNode)object);
                    } else {
                        lQJoinNode.setJoinType(305);
                    }
                } else {
                    string = ((LQCondNode)object).toString();
                    lQJoinNode.setContent(string);
                    lQJoinNode.setCondition((LQCondNode)object);
                }
                if (lQCondNode2 != null) {
                    lQJoinNode.setFilterCondition(lQCondNode2);
                }
            }
        }
        object = simpleNode2.toString().toUpperCase();
        if (((String)object).indexOf("LEFT") >= 0) {
            lQJoinNode.setLeftOuterJoin(true);
        } else if (((String)object).indexOf("RIGHT") >= 0) {
            lQJoinNode.setRightOuterJoin(true);
        } else if (((String)object).indexOf("FULL") >= 0) {
            lQJoinNode.setRightOuterJoin(true);
            lQJoinNode.setLeftOuterJoin(true);
        }
        return lQJoinNode;
    }

    private void connectTableNodes(LQNode lQNode) {
        LQNode lQNode2;
        LQNode lQNode3;
        Object object;
        HashMap<String, GQTableRef> hashMap = this.subQuery.getTableRefs();
        Iterator<String> iterator = hashMap.keySet().iterator();
        if (hashMap.size() == 0) {
            LQRowNode lQRowNode = new LQRowNode();
            lQNode.addChild(lQRowNode);
            return;
        }
        if (hashMap.size() == 1) {
            LQNode lQNode4 = hashMap.get(iterator.next()).getNode();
            lQNode4.setParent(lQNode);
            lQNode.addChild(lQNode4);
            return;
        }
        LQProductNode lQProductNode = new LQProductNode();
        HashMap<Object, LQNode> hashMap2 = new HashMap<Object, LQNode>();
        while (iterator.hasNext()) {
            object = iterator.next();
            lQNode3 = hashMap.get(object).getNode();
            if (lQNode3.getParent() == null) {
                lQProductNode.addChild(lQNode3);
                lQNode3.setParent(lQProductNode);
                continue;
            }
            lQNode2 = lQNode3;
            while (lQNode2.getParent() != null) {
                lQNode2 = lQNode2.getParent();
            }
            if (hashMap2.containsKey(lQNode2.getContent())) continue;
            hashMap2.put(lQNode2.getContent(), lQNode2);
        }
        if (hashMap2.size() == 1 && lQProductNode.getNumChildren() == 0) {
            object = hashMap2.keySet().iterator();
            lQNode3 = (LQNode)hashMap2.get(object.next());
            lQNode3.setParent(lQNode);
            lQNode.addChild(lQNode3);
        } else {
            object = hashMap2.keySet().iterator();
            while (object.hasNext()) {
                lQNode3 = (LQNode)hashMap2.get(object.next());
                lQNode3.setParent(lQProductNode);
                lQProductNode.addChild(lQNode3);
            }
            if (lQProductNode.getNumChildren() > 2) {
                int n = lQProductNode.getNumChildren();
                lQNode2 = new LQProductNode();
                LQNode lQNode5 = lQProductNode.getChild(n - 1);
                lQNode5.setParent(lQNode2);
                lQNode2.addChild(lQNode5);
                lQNode5 = lQProductNode.getChild(n - 2);
                lQNode5.setParent(lQNode2);
                lQNode2.addChild(lQNode5);
                lQProductNode.removeChild(n - 1);
                lQProductNode.removeChild(n - 2);
                LQNode lQNode6 = lQNode2;
                while (lQProductNode.getNumChildren() >= 2) {
                    n = lQProductNode.getNumChildren();
                    lQNode2 = new LQProductNode();
                    lQNode5 = lQProductNode.getChild(n - 1);
                    lQNode5.setParent(lQNode2);
                    lQNode2.addChild(lQNode5);
                    lQNode2.addChild(lQNode6);
                    lQNode6.setParent(lQNode2);
                    lQNode6 = lQNode2;
                    lQProductNode.removeChild(n - 1);
                }
                lQProductNode.addChild(lQNode6);
                lQNode6.setParent(lQProductNode);
            }
            lQProductNode.setParent(lQNode);
            lQNode.addChild(lQProductNode);
        }
    }

    private LQSelNode buildConditionNodes(SimpleNode simpleNode, LQNode lQNode, HashMap<String, GQFieldRef> hashMap) throws SQLException {
        LQSelNode lQSelNode = null;
        String string = simpleNode.toString().toLowerCase();
        if (string.equals("and")) {
            LQNode lQNode2 = lQNode;
            int n = simpleNode.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (this.isJoinCondition(simpleNode2) && !this.subQuery.hasParent()) {
                    this.createJoinNode(simpleNode2, hashMap);
                    continue;
                }
                lQSelNode = new LQSelNode();
                lQSelNode.setCondition(this.buildConditionNode(simpleNode2, 207, null, hashMap));
                lQSelNode.setParent(lQNode2);
                if (lQNode2 != null) {
                    lQNode2.addChild(lQSelNode);
                }
                lQNode2 = lQSelNode;
            }
        } else if (this.isJoinCondition(simpleNode) && !this.subQuery.hasParent()) {
            this.createJoinNode(simpleNode, hashMap);
        } else {
            lQSelNode = new LQSelNode();
            lQSelNode.setCondition(this.buildConditionNode(simpleNode, 207, null, hashMap));
            lQSelNode.setParent(lQNode);
            lQNode.addChild(lQSelNode);
        }
        return lQSelNode;
    }

    private LQSelNode buildHavingNode(SimpleNode simpleNode, LQGroupByNode lQGroupByNode, HashMap<String, GQFieldRef> hashMap) throws SQLException {
        LQSelNode lQSelNode = new LQSelNode();
        lQSelNode.setHavingCondition(true);
        lQSelNode.setCondition(this.buildConditionNode(simpleNode, 9, lQGroupByNode, hashMap));
        return lQSelNode;
    }

    private void createJoinNode(SimpleNode simpleNode, HashMap<String, GQFieldRef> hashMap) throws SQLException {
        LQJoinNode lQJoinNode;
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
        SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(1);
        String string = simpleNode2.toString().substring(12);
        String string2 = simpleNode3.toString().substring(12);
        String string3 = simpleNode.toString().substring(15);
        String string4 = string + ' ' + string3 + ' ' + string2;
        LQCondNode lQCondNode = this.buildConditionNode(simpleNode, 207, null, hashMap);
        GQFieldRef gQFieldRef = (GQFieldRef)simpleNode2.getReference();
        GQFieldRef gQFieldRef2 = (GQFieldRef)simpleNode3.getReference();
        GQTableRef gQTableRef = gQFieldRef.getTable();
        if (gQTableRef == null) {
            throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.InvalidTableReference") + gQFieldRef);
        }
        GQTableRef gQTableRef2 = gQFieldRef2.getTable();
        if (gQTableRef2 == null) {
            throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.InvalidTableReference") + gQFieldRef2);
        }
        LQNode lQNode = gQTableRef.getNode();
        LQNode lQNode2 = gQTableRef2.getNode();
        if (lQNode.getParent() == null || lQNode2.getParent() == null) {
            LQJoinNode lQJoinNode2 = new LQJoinNode();
            lQJoinNode2.setContent(string4);
            lQJoinNode2.setCondition(lQCondNode);
            lQJoinNode2.addChild(lQNode);
            lQJoinNode2.addChild(lQNode2);
            this.joinList.add(lQJoinNode2);
            while (lQNode.getParent() != null) {
                lQNode = lQNode.getParent();
            }
            while (lQNode2.getParent() != null) {
                lQNode2 = lQNode2.getParent();
            }
            lQJoinNode = new LQJoinNode();
            lQJoinNode.setContent(string4);
            lQJoinNode.setCondition(lQCondNode);
            lQJoinNode.addChild(lQNode);
            lQJoinNode.addChild(lQNode2);
            lQNode.setParent(lQJoinNode);
            lQNode2.setParent(lQJoinNode);
        } else {
            int n;
            ArrayList<LQNode> arrayList = new ArrayList<LQNode>();
            while (lQNode.getParent() != null) {
                arrayList.add(0, lQNode.getParent());
                lQNode = lQNode.getParent();
            }
            ArrayList<LQNode> arrayList2 = new ArrayList<LQNode>();
            while (lQNode2.getParent() != null) {
                arrayList2.add(0, lQNode2.getParent());
                lQNode2 = lQNode2.getParent();
            }
            for (n = 0; n < arrayList.size() && n < arrayList2.size() && arrayList.get(n) == arrayList2.get(n); ++n) {
            }
            if (--n == -1) {
                LQJoinNode lQJoinNode3 = new LQJoinNode();
                lQJoinNode3.setContent(string4);
                lQJoinNode3.setCondition(lQCondNode);
                lQJoinNode3.addChild(lQNode);
                lQJoinNode3.addChild(lQNode2);
                this.joinList.add(lQJoinNode3);
                while (lQNode.getParent() != null) {
                    lQNode = lQNode.getParent();
                }
                while (lQNode2.getParent() != null) {
                    lQNode2 = lQNode2.getParent();
                }
                lQJoinNode = new LQJoinNode();
                lQJoinNode.setContent(string4);
                lQJoinNode.setCondition(lQCondNode);
                lQJoinNode.addChild(lQNode);
                lQJoinNode.addChild(lQNode2);
                lQNode.setParent(lQJoinNode);
                lQNode2.setParent(lQJoinNode);
            } else {
                lQJoinNode = (LQJoinNode)arrayList.get(n);
                String string5 = (String)lQJoinNode.getContent();
                LQCondNode lQCondNode2 = lQJoinNode.getCondition();
                lQJoinNode.setContent(string5 + " AND " + string4);
                LQCondNode lQCondNode3 = new LQCondNode();
                lQCondNode3.setType(111);
                lQCondNode3.setContent("AND");
                lQCondNode3.addChild(lQCondNode);
                lQCondNode3.addChild(lQCondNode2);
                lQJoinNode.setCondition(lQCondNode3);
                for (n = 0; n < this.joinList.size(); ++n) {
                    LQJoinNode lQJoinNode4 = this.joinList.get(n);
                    if (lQJoinNode4.getCondition() != lQCondNode2) continue;
                    lQJoinNode4.setCondition(lQCondNode3);
                    lQJoinNode4.setContent(string5 + " AND " + string4);
                    break;
                }
            }
        }
        if (lQNode.getReference() == lQNode2.getReference()) {
            lQJoinNode.setReference(lQNode.getReference());
        } else {
            lQJoinNode.setReference(null);
        }
    }

    public LQCondNode buildConditionNode(SimpleNode simpleNode, int n, LQNode lQNode, HashMap<String, GQFieldRef> hashMap) throws SQLException {
        LQCondNode lQCondNode = new LQCondNode();
        String string = "";
        String string2 = simpleNode.toString().toLowerCase();
        int n2 = -1;
        if (string2.equals("or")) {
            n2 = 110;
            string = "OR";
        } else if (string2.equals("and")) {
            n2 = 111;
            string = "AND";
        } else if (string2.equals("not")) {
            n2 = 112;
            string = "NOT";
        } else if (string2.equals("xor")) {
            n2 = 118;
            string = "XOR";
        }
        if (n2 == 112) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
            LQCondNode lQCondNode2 = this.buildConditionNode(simpleNode2, n, lQNode, hashMap);
            lQCondNode.addChild(lQCondNode2);
            lQCondNode2.setParent(lQCondNode);
        } else if (n2 == 110 || n2 == 111 || n2 == 118) {
            int n3 = simpleNode.jjtGetNumChildren();
            lQCondNode = this.buildConditionNode((SimpleNode)simpleNode.jjtGetChild(0), n, lQNode, hashMap);
            for (int i = 1; i < n3; ++i) {
                LQCondNode lQCondNode3 = this.buildConditionNode((SimpleNode)simpleNode.jjtGetChild(i), n, lQNode, hashMap);
                LQCondNode lQCondNode4 = new LQCondNode();
                lQCondNode4.addChild(lQCondNode);
                lQCondNode.setParent(lQCondNode4);
                lQCondNode4.addChild(lQCondNode3);
                lQCondNode3.setParent(lQCondNode4);
                lQCondNode4.setType(n2);
                lQCondNode4.setContent(string);
                lQCondNode = lQCondNode4;
            }
        } else if (string2.equals("in")) {
            n2 = 113;
            string = "IN";
        } else {
            if (simpleNode instanceof ASTFunction) {
                lQCondNode.setType(129);
                lQCondNode.setContent(simpleNode.toString().substring(10));
                if (simpleNode.jjtGetNumChildren() < 3) {
                    throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorNPFuncRequiresThreeParam"));
                }
                for (int i = 0; i < 3; ++i) {
                    lQCondNode.addChild(this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(i), lQNode, hashMap));
                }
                return lQCondNode;
            }
            if (simpleNode instanceof ASTExists) {
                n2 = 135;
                string = "EXISTS";
                lQCondNode.addChild(this.BuildExpressionNode(n, (SimpleNode)simpleNode.jjtGetChild(0), lQNode, hashMap));
            } else {
                if (simpleNode instanceof ASTMyID) {
                    throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.ErrorBooleanValueInCondition") + simpleNode.toString());
                }
                n2 = 114;
                String string3 = simpleNode.toString().substring(15).toUpperCase();
                if (string3.contains("BETWEEN")) {
                    SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(0);
                    SimpleNode simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(1);
                    SimpleNode simpleNode5 = (SimpleNode)simpleNode.jjtGetChild(2);
                    LQExprNode lQExprNode = this.BuildExpressionNode(n, simpleNode3, lQNode, hashMap);
                    LQExprNode lQExprNode2 = this.BuildExpressionNode(n, simpleNode4, lQNode, hashMap);
                    LQExprNode lQExprNode3 = this.BuildExpressionNode(n, simpleNode5, lQNode, hashMap);
                    if (string3.contains("NOT")) {
                        lQCondNode.setType(110);
                        lQCondNode.setContent("OR");
                        LQCondNode lQCondNode5 = new LQCondNode();
                        lQCondNode5.setType(114);
                        lQCondNode5.setContent("<");
                        lQCondNode5.addChild(lQExprNode);
                        lQCondNode5.addChild(lQExprNode2);
                        lQCondNode.addChild(lQCondNode5);
                        LQCondNode lQCondNode6 = new LQCondNode();
                        lQCondNode6.setType(114);
                        lQCondNode6.setContent(">");
                        lQCondNode6.addChild(lQExprNode);
                        lQCondNode6.addChild(lQExprNode3);
                        lQCondNode.addChild(lQCondNode6);
                    } else {
                        lQCondNode.setType(111);
                        lQCondNode.setContent("AND");
                        LQCondNode lQCondNode7 = new LQCondNode();
                        lQCondNode7.setType(114);
                        lQCondNode7.setContent(">=");
                        lQCondNode7.addChild(lQExprNode);
                        lQCondNode7.addChild(lQExprNode2);
                        lQCondNode.addChild(lQCondNode7);
                        LQCondNode lQCondNode8 = new LQCondNode();
                        lQCondNode8.setType(114);
                        lQCondNode8.setContent("<=");
                        lQCondNode8.addChild(lQExprNode);
                        lQCondNode8.addChild(lQExprNode3);
                        lQCondNode.addChild(lQCondNode8);
                    }
                    return lQCondNode;
                }
                SimpleNode simpleNode6 = (SimpleNode)simpleNode.jjtGetChild(0);
                SimpleNode simpleNode7 = (SimpleNode)simpleNode.jjtGetChild(1);
                string = string3;
                LQExprNode lQExprNode = this.BuildExpressionNode(n, simpleNode6, lQNode, hashMap);
                LQExprNode lQExprNode4 = this.BuildExpressionNode(n, simpleNode7, lQNode, hashMap);
                lQCondNode.addChild(lQExprNode);
                lQExprNode.setParent(lQCondNode);
                lQCondNode.addChild(lQExprNode4);
                lQExprNode4.setParent(lQCondNode);
            }
        }
        lQCondNode.setType(n2);
        lQCondNode.setContent(string);
        return lQCondNode;
    }

    public boolean isJoinCondition(SimpleNode simpleNode) throws SQLException {
        if (simpleNode instanceof ASTCop && ((ASTCop)simpleNode).getName().equals("=")) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
            SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(1);
            if (simpleNode2 instanceof ASTMyID && simpleNode3 instanceof ASTMyID) {
                String string = simpleNode2.toString().substring(12);
                String string2 = simpleNode3.toString().substring(12);
                GQFieldRef gQFieldRef = (GQFieldRef)simpleNode2.getReference();
                GQFieldRef gQFieldRef2 = (GQFieldRef)simpleNode3.getReference();
                if (gQFieldRef == null) {
                    throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.InvalidJoinFieldReference") + string);
                }
                if (gQFieldRef2 == null) {
                    throw new SQLException(UnityDriver.i18n.getString("LQTreeBuilder.InvalidJoinFieldReference") + string2);
                }
                if (gQFieldRef.getReference() != null || gQFieldRef2.getReference() != null) {
                    return false;
                }
                return gQFieldRef.getTable() != gQFieldRef2.getTable();
            }
        }
        return false;
    }
}

