/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.math.BigDecimal;
import java.sql.SQLException;
import unity.predicates.Predicate;

public class Equal
extends Predicate {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean evaluate(Object object, Object object2) throws SQLException {
        return Equal.isEqual(object, object2);
    }

    public String toString() {
        return "=";
    }

    public static boolean isEqual(Object object, Object object2) throws SQLException {
        Class<?> clazz;
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz2 == (clazz = object2.getClass())) {
            if (object instanceof String) {
                return Equal.compareStrings((String)object, (String)object2);
            }
            return object.equals(object2);
        }
        if (object instanceof Number && object2 instanceof Number) {
            if (object instanceof Double || object instanceof BigDecimal || object instanceof Float || object2 instanceof Double || object2 instanceof BigDecimal || object2 instanceof Float) {
                return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
            }
            return ((Number)object).longValue() == ((Number)object2).longValue();
        }
        Object[] objectArray = Predicate.convertTypes(object, object2);
        return ((Comparable)objectArray[0]).equals(objectArray[1]);
    }

    public static boolean compareStrings(String string, String string2) {
        int n;
        String string3 = string;
        String string4 = string2;
        int n2 = string3.length();
        if (n2 != (n = string4.length())) {
            if (n2 > n) {
                string4 = String.format("%1$-" + n2 + "s", string4);
            } else {
                string3 = String.format("%1$-" + n + "s", string3);
            }
        }
        return string3.equals(string4);
    }
}

