/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import unity.query.DPNode;
import unity.query.DPTable;
import unity.query.HGHyperEdge;
import unity.query.HGNode;
import unity.query.LQCondNode;
import unity.query.LQJoinNode;
import unity.query.LQNode;

public class HyperGraph {
    private HGNode[] nodes;
    private ArrayList<HGHyperEdge> hyperEdges;
    private int numNodes;
    private ArrayList<LQJoinNode> joinList;
    private DPTable table;
    private LQNode root;
    private boolean allConnected;

    public HyperGraph(int n, ArrayList<LQJoinNode> arrayList, LQNode lQNode) {
        this.nodes = new HGNode[n];
        this.hyperEdges = new ArrayList();
        this.joinList = arrayList;
        this.table = new DPTable(n);
        this.allConnected = true;
        this.root = lQNode;
    }

    public void insert(HGNode hGNode) {
        this.nodes[this.numNodes] = hGNode;
        hGNode.setPosition(this.numNodes);
        ++this.numNodes;
    }

    public void updateJoins() {
        int n;
        int n2 = this.joinList.size();
        for (n = 0; n < n2; ++n) {
            LQJoinNode lQJoinNode = this.joinList.get(n);
            ArrayList<LQJoinNode> arrayList = lQJoinNode.getSplitJoins();
            if (arrayList == null) continue;
            arrayList.get(0).setFilterCondition(this.joinList.get(n).getFilterCondition());
            this.joinList.set(n, arrayList.get(0));
            for (int i = 1; i < arrayList.size(); ++i) {
                this.joinList.add(arrayList.get(i));
            }
        }
        n2 = this.joinList.size();
        for (n = 0; n < this.nodes.length; ++n) {
            this.nodes[n].setJoinSize(n2);
        }
    }

    public void updateComplexJoins() {
        for (int i = 0; i < this.hyperEdges.size(); ++i) {
            HGHyperEdge hGHyperEdge = this.hyperEdges.get(i);
            BitSet bitSet = hGHyperEdge.getLeftRelations();
            BitSet bitSet2 = hGHyperEdge.getRightRelations();
            if (bitSet.cardinality() == 1) {
                this.nodes[bitSet.nextSetBit(0)].addJoin(hGHyperEdge.getPosition());
            }
            if (bitSet2.cardinality() != 1) continue;
            this.nodes[bitSet2.nextSetBit(0)].addJoin(hGHyperEdge.getPosition());
        }
    }

    public void addEdge(HGNode hGNode, HGNode hGNode2, int n) {
        hGNode.addEdge(hGNode2.getPosition(), n);
        hGNode2.addEdge(hGNode.getPosition(), n);
    }

    public void addHyperEdge(HGHyperEdge hGHyperEdge) {
        this.hyperEdges.add(hGHyperEdge);
    }

    public HGNode[] getNodes() {
        return this.nodes;
    }

    public ArrayList<HGHyperEdge> getHyperEdges() {
        return this.hyperEdges;
    }

    public HGNode getNodeAt(int n) {
        return this.nodes[n];
    }

    public void setAllConnected(boolean bl) {
        this.allConnected = bl;
    }

    public LQNode getRoot() {
        return this.root;
    }

    public void depthFirstTraverse(int n, BitSet bitSet) {
        bitSet.set(n);
        BitSet bitSet2 = this.nodes[n].getNodes();
        int n2 = bitSet2.nextSetBit(0);
        while (n2 >= 0) {
            if (!bitSet.get(n2)) {
                this.depthFirstTraverse(n2, bitSet);
            }
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
    }

    public void findAndRemoveUnconnectedHypEdges() {
        Serializable serializable;
        HGHyperEdge hGHyperEdge;
        int n;
        if (this.allConnected) {
            return;
        }
        int n2 = 0;
        ArrayList<HGHyperEdge> arrayList = new ArrayList<HGHyperEdge>();
        for (n = 0; n < this.hyperEdges.size(); ++n) {
            int n3;
            BitSet bitSet;
            BitSet bitSet2;
            BitSet bitSet3;
            int n4;
            hGHyperEdge = this.hyperEdges.get(n);
            if (!hGHyperEdge.isLeftConnected()) {
                serializable = (BitSet)hGHyperEdge.getRightRelations().clone();
                n4 = hGHyperEdge.getLeftRelations().nextSetBit(0);
                this.depthFirstTraverse(n4, (BitSet)serializable);
                bitSet3 = (BitSet)((BitSet)serializable).clone();
                bitSet3.and(hGHyperEdge.getLeftRelations());
                if (bitSet3.equals(hGHyperEdge.getLeftRelations())) {
                    hGHyperEdge.setLeftConnected();
                } else {
                    bitSet2 = (BitSet)hGHyperEdge.getRightRelations().clone();
                    bitSet2.flip(0, this.nodes.length);
                    bitSet2.and((BitSet)serializable);
                    hGHyperEdge.addLeftSet(bitSet2);
                    bitSet = (BitSet)((BitSet)serializable).clone();
                    bitSet.flip(0, this.nodes.length);
                    bitSet.and(hGHyperEdge.getLeftRelations());
                    serializable = (BitSet)hGHyperEdge.getRightRelations().clone();
                    n3 = bitSet.nextSetBit(0);
                    while (n3 >= 0) {
                        this.depthFirstTraverse(n3, (BitSet)serializable);
                        bitSet2 = (BitSet)hGHyperEdge.getRightRelations().clone();
                        bitSet2.flip(0, this.nodes.length);
                        bitSet2.and((BitSet)serializable);
                        hGHyperEdge.addLeftSet(bitSet2);
                        bitSet3 = (BitSet)((BitSet)serializable).clone();
                        bitSet3.flip(0, this.nodes.length);
                        bitSet.and(bitSet3);
                        n3 = bitSet.nextSetBit(n3 + 1);
                    }
                }
            }
            if (!hGHyperEdge.isRightConnected()) {
                serializable = (BitSet)hGHyperEdge.getLeftRelations().clone();
                n4 = hGHyperEdge.getRightRelations().nextSetBit(0);
                this.depthFirstTraverse(n4, (BitSet)serializable);
                bitSet3 = (BitSet)((BitSet)serializable).clone();
                bitSet3.and(hGHyperEdge.getRightRelations());
                if (bitSet3.equals(hGHyperEdge.getRightRelations())) {
                    hGHyperEdge.setRightConnected();
                } else {
                    bitSet2 = (BitSet)hGHyperEdge.getLeftRelations().clone();
                    bitSet2.flip(0, this.nodes.length);
                    bitSet2.and((BitSet)serializable);
                    hGHyperEdge.addRightSet(bitSet2);
                    bitSet = (BitSet)((BitSet)serializable).clone();
                    bitSet.flip(0, this.nodes.length);
                    bitSet.and(hGHyperEdge.getRightRelations());
                    serializable = (BitSet)hGHyperEdge.getLeftRelations().clone();
                    n3 = bitSet.nextSetBit(0);
                    while (n3 >= 0) {
                        this.depthFirstTraverse(n3, (BitSet)serializable);
                        bitSet2 = (BitSet)hGHyperEdge.getLeftRelations().clone();
                        bitSet2.flip(0, this.nodes.length);
                        bitSet2.and((BitSet)serializable);
                        hGHyperEdge.addRightSet(bitSet2);
                        bitSet3 = (BitSet)((BitSet)serializable).clone();
                        bitSet3.flip(0, this.nodes.length);
                        bitSet.and(bitSet3);
                        n3 = bitSet.nextSetBit(n3 + 1);
                    }
                }
            }
            if (hGHyperEdge.isConnected()) continue;
            ++n2;
            arrayList.add(hGHyperEdge);
        }
        for (n = 0; n < this.hyperEdges.size() && n2 > 0; ++n) {
            if (!this.hyperEdges.get(n).isConnected()) continue;
            n2 = this.addConnections(this.hyperEdges.get(n), arrayList, n2);
        }
        if (n2 > 0) {
            for (n = 0; n < this.hyperEdges.size(); ++n) {
                if (this.hyperEdges.get(n).isConnected()) continue;
                hGHyperEdge = this.hyperEdges.get(n);
                serializable = this.joinList.get(hGHyperEdge.getPosition());
                ((LQJoinNode)serializable).getSelNode().setComplexJoin(null);
                this.hyperEdges.remove(n);
                --n;
            }
        }
    }

    public int addConnections(HGHyperEdge hGHyperEdge, ArrayList<HGHyperEdge> arrayList, int n) {
        int n2 = n;
        for (int i = 0; i < arrayList.size() && n2 > 0; ++i) {
            int n3;
            BitSet bitSet;
            ArrayList<BitSet> arrayList2;
            BitSet bitSet2 = (BitSet)hGHyperEdge.getLeftRelations().clone();
            bitSet2.or(hGHyperEdge.getRightRelations());
            if (arrayList.get(i).isConnected()) continue;
            HGHyperEdge hGHyperEdge2 = arrayList.get(i);
            if (!hGHyperEdge2.isLeftConnected()) {
                arrayList2 = hGHyperEdge2.getLeftSets();
                bitSet = new BitSet(this.nodes.length);
                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                    if (!bitSet2.intersects(arrayList2.get(n3))) continue;
                    bitSet.or(arrayList2.get(n3));
                    arrayList2.remove(n3);
                    --n3;
                }
                if (arrayList2.size() == 0) {
                    hGHyperEdge2.setLeftConnected();
                } else {
                    arrayList2.add(bitSet);
                }
            }
            if (!hGHyperEdge2.isRightConnected()) {
                arrayList2 = hGHyperEdge2.getRightSets();
                bitSet = new BitSet(this.nodes.length);
                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                    if (!bitSet2.intersects(arrayList2.get(n3))) continue;
                    bitSet.or(arrayList2.get(n3));
                    arrayList2.remove(n3);
                    --n3;
                }
                if (arrayList2.size() == 0) {
                    hGHyperEdge2.setRightConnected();
                } else {
                    arrayList2.add(bitSet);
                }
            }
            if (!hGHyperEdge2.isConnected()) continue;
            --n2;
            n2 = this.addConnections(hGHyperEdge2, arrayList, n2);
        }
        return n2;
    }

    public void removeConflictingHyperEdges() {
        for (int i = 0; i < this.hyperEdges.size(); ++i) {
            HGHyperEdge hGHyperEdge = this.hyperEdges.get(i);
            LQJoinNode lQJoinNode = this.joinList.get(hGHyperEdge.getPosition());
            if (!lQJoinNode.mayConflict) continue;
            for (int j = 0; j < this.hyperEdges.size(); ++j) {
                HGHyperEdge hGHyperEdge2 = this.hyperEdges.get(j);
                if (this.joinList.get((int)hGHyperEdge2.getPosition()).mayConflict || !this.edgesConflict(hGHyperEdge, hGHyperEdge2)) continue;
                lQJoinNode.getSelNode().setComplexJoin(null);
                this.hyperEdges.remove(i);
                --i;
                break;
            }
            lQJoinNode.setMayConflict(false);
        }
    }

    private boolean edgesConflict(HGHyperEdge hGHyperEdge, HGHyperEdge hGHyperEdge2) {
        int n = 0;
        if (hGHyperEdge.getLeftRelations().intersects(hGHyperEdge2.getLeftRelations())) {
            ++n;
        }
        if (hGHyperEdge.getLeftRelations().intersects(hGHyperEdge2.getRightRelations())) {
            ++n;
        }
        if (hGHyperEdge.getRightRelations().intersects(hGHyperEdge2.getLeftRelations())) {
            ++n;
        }
        if (hGHyperEdge.getRightRelations().intersects(hGHyperEdge2.getRightRelations())) {
            ++n;
        }
        return n > 2;
    }

    public ArrayList<HGNode> bitSetToList(BitSet bitSet) {
        ArrayList<HGNode> arrayList = new ArrayList<HGNode>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            arrayList.add(this.nodes[n]);
            n = bitSet.nextSetBit(n + 1);
        }
        return arrayList;
    }

    public BitSet listToBitSet(ArrayList<HGNode> arrayList) {
        BitSet bitSet = new BitSet(this.nodes.length);
        for (int i = 0; i < arrayList.size(); ++i) {
            bitSet.set(arrayList.get(i).getPosition());
        }
        return bitSet;
    }

    public BitSet neighbourhood(ArrayList<HGNode> arrayList, BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = new BitSet(this.nodes.length);
        BitSet bitSet4 = (BitSet)bitSet.clone();
        bitSet4.flip(0, this.nodes.length);
        bitSet4.and(bitSet2);
        for (int i = 0; i < arrayList.size(); ++i) {
            bitSet3.or(arrayList.get(i).getNodes());
        }
        bitSet3.and(bitSet4);
        ArrayList<BitSet> arrayList2 = new ArrayList<BitSet>();
        int n = 0;
        while (n / 2 < this.hyperEdges.size()) {
            BitSet bitSet5;
            BitSet bitSet6;
            BitSet bitSet7;
            BitSet bitSet8;
            HGHyperEdge hGHyperEdge = this.hyperEdges.get(n / 2);
            if (n % 2 == 0) {
                bitSet8 = (BitSet)hGHyperEdge.getLeftRelations().clone();
                bitSet7 = hGHyperEdge.getLeftRelations();
                bitSet6 = (BitSet)hGHyperEdge.getRightRelations().clone();
                bitSet5 = hGHyperEdge.getRightRelations();
            } else {
                bitSet8 = (BitSet)hGHyperEdge.getRightRelations().clone();
                bitSet7 = hGHyperEdge.getRightRelations();
                bitSet6 = (BitSet)hGHyperEdge.getLeftRelations().clone();
                bitSet5 = hGHyperEdge.getLeftRelations();
            }
            bitSet8.and(bitSet);
            if (bitSet8.equals(bitSet7)) {
                bitSet6.and(bitSet4);
                if (bitSet6.equals(bitSet5) && !bitSet6.intersects(bitSet3)) {
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        BitSet bitSet9 = (BitSet)((BitSet)arrayList2.get(n2)).clone();
                        bitSet9.and(bitSet6);
                        if (bitSet9.equals(arrayList2.get(n2))) break;
                        if (bitSet9.equals(bitSet6)) {
                            arrayList2.remove(n2);
                            continue;
                        }
                        ++n2;
                    }
                    if (n2 == arrayList2.size()) {
                        arrayList2.add(bitSet6);
                    }
                }
            }
            ++n;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            bitSet3.set(((BitSet)arrayList2.get(n)).nextSetBit(0));
        }
        return bitSet3;
    }

    public LQNode solve() throws SQLException {
        Serializable serializable;
        Object object;
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            object = new BitSet(this.nodes.length);
            ((BitSet)object).set(n);
            this.table.insert((BitSet)object, new DPNode(this.nodes[n]));
        }
        for (n = this.nodes.length - 1; n >= 0; --n) {
            object = new BitSet(this.nodes.length);
            ((BitSet)object).set(n);
            this.EmitCsg((BitSet)object);
            BitSet bitSet = (BitSet)((BitSet)object).clone();
            bitSet.flip(n, this.nodes.length);
            this.EnumerateCsgRec((BitSet)object, bitSet);
        }
        BitSet bitSet = new BitSet(this.nodes.length);
        bitSet.flip(0, this.nodes.length);
        object = this.table.find(bitSet);
        if (object == null) {
            int n2 = this.table.findMin();
            serializable = DPTable.indexToKey(n2);
            int n3 = this.table.size() - n2 - 1;
            BitSet bitSet2 = DPTable.indexToKey(n3);
            this.EmitCsg((BitSet)serializable);
            this.EnumerateCsgRec((BitSet)serializable, bitSet2);
            object = this.table.find(bitSet);
            if (object == null) {
                return this.root;
            }
        }
        LQNode lQNode = ((DPNode)object).getRoot();
        if (this.root.getType() == 207) {
            serializable = this.root.getParent();
            if (serializable != null) {
                if (((LQNode)serializable).getChild(0) == this.root) {
                    ((LQNode)serializable).setChild(0, lQNode);
                } else {
                    ((LQNode)serializable).setChild(1, lQNode);
                }
            }
            lQNode.setParent((LQNode)serializable);
        }
        return lQNode;
    }

    public void EnumerateCsgRec(BitSet bitSet, BitSet bitSet2) {
        ArrayList<HGNode> arrayList = this.bitSetToList(bitSet);
        BitSet bitSet3 = this.neighbourhood(arrayList, bitSet, bitSet2);
        if (bitSet3.cardinality() > 0) {
            BitSet bitSet4 = (BitSet)bitSet3.clone();
            bitSet4.flip(0, this.nodes.length);
            bitSet4.and(bitSet2);
            int n = bitSet3.nextSetBit(0);
            while (n >= 0) {
                bitSet.set(n);
                DPNode dPNode = this.table.find(bitSet);
                if (dPNode != null) {
                    this.EmitCsg(bitSet);
                }
                this.EnumerateCsgRec(bitSet, bitSet4);
                bitSet.clear(n);
                n = bitSet3.nextSetBit(n + 1);
            }
        }
    }

    public void EmitCsg(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)bitSet.clone();
        int n = bitSet2.nextSetBit(0);
        bitSet2.flip(n, this.nodes.length);
        ArrayList<HGNode> arrayList = this.bitSetToList(bitSet);
        BitSet bitSet3 = this.neighbourhood(arrayList, bitSet, bitSet2);
        BitSet bitSet4 = new BitSet(this.nodes.length);
        int n2 = bitSet3.nextSetBit(0);
        while (n2 >= 0) {
            bitSet4.set(n2);
            if (this.connected(bitSet, bitSet4)) {
                this.EmitCsgCmp(bitSet, bitSet4);
            }
            this.EnumerateCmpRec(bitSet, bitSet4, bitSet2);
            bitSet4.clear(n2);
            n2 = bitSet3.nextSetBit(n2 + 1);
        }
    }

    public void EnumerateCmpRec(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        ArrayList<HGNode> arrayList = this.bitSetToList(bitSet2);
        BitSet bitSet4 = this.neighbourhood(arrayList, bitSet2, bitSet3);
        int n = bitSet4.nextSetBit(0);
        while (n >= 0) {
            bitSet2.set(n);
            DPNode dPNode = this.table.find(bitSet2);
            if (dPNode != null && this.connected(bitSet, bitSet2)) {
                this.EmitCsgCmp(bitSet, bitSet2);
            }
            bitSet2.clear(n);
            n = bitSet4.nextSetBit(n + 1);
        }
        BitSet bitSet5 = (BitSet)bitSet4.clone();
        bitSet5.flip(0, this.nodes.length);
        bitSet3.and(bitSet5);
        int n2 = bitSet4.nextSetBit(0);
        while (n2 >= 0) {
            bitSet2.set(n2);
            this.EnumerateCmpRec(bitSet, bitSet2, bitSet3);
            bitSet2.clear(n2);
            n2 = bitSet4.nextSetBit(n2 + 1);
        }
    }

    public void EmitCsgCmp(BitSet bitSet, BitSet bitSet2) {
        Object object;
        LQJoinNode lQJoinNode;
        DPNode dPNode = this.table.find(bitSet);
        DPNode dPNode2 = this.table.find(bitSet2);
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.or(bitSet2);
        BitSet bitSet4 = (BitSet)dPNode.getJoins().clone();
        bitSet4.and(dPNode2.getJoins());
        if (bitSet4.cardinality() == 1) {
            lQJoinNode = this.joinList.get(bitSet4.nextSetBit(0)).clone();
        } else {
            int n = bitSet4.nextSetBit(0);
            lQJoinNode = this.joinList.get(n).clone();
            while (n >= 0) {
                object = lQJoinNode;
                lQJoinNode = this.joinList.get(n);
                lQJoinNode = this.mergeJoinNodes(lQJoinNode, (LQJoinNode)object);
                n = bitSet4.nextSetBit(n + 1);
            }
        }
        if (lQJoinNode.leftTables.intersects(bitSet)) {
            if (lQJoinNode.children == null) {
                lQJoinNode.addChild(null);
                lQJoinNode.addChild(null);
            }
            lQJoinNode.setChild(0, dPNode.getRoot());
            lQJoinNode.setChild(1, dPNode2.getRoot());
        } else {
            if (lQJoinNode.children == null) {
                lQJoinNode.addChild(null);
                lQJoinNode.addChild(null);
            }
            lQJoinNode.setChild(0, dPNode2.getRoot());
            lQJoinNode.setChild(1, dPNode.getRoot());
        }
        dPNode.getRoot().setParent(lQJoinNode);
        dPNode2.getRoot().setParent(lQJoinNode);
        lQJoinNode.computeCost();
        DPNode dPNode3 = this.table.find(bitSet3);
        if (dPNode3 == null) {
            object = new DPNode(lQJoinNode, this.joinList.size());
            BitSet bitSet5 = (BitSet)dPNode.getJoins().clone();
            bitSet5.xor(dPNode2.getJoins());
            for (int i = 0; i < this.hyperEdges.size(); ++i) {
                BitSet bitSet6;
                HGHyperEdge hGHyperEdge = this.hyperEdges.get(i);
                int n = hGHyperEdge.getPosition();
                if (!hGHyperEdge.getRightRelations().intersects(bitSet3)) {
                    bitSet6 = (BitSet)hGHyperEdge.getLeftRelations().clone();
                    bitSet6.and(bitSet3);
                    if (!bitSet6.equals(hGHyperEdge.getLeftRelations())) continue;
                    bitSet5.set(n);
                    continue;
                }
                if (!hGHyperEdge.getLeftRelations().intersects(bitSet3)) {
                    bitSet6 = (BitSet)hGHyperEdge.getRightRelations().clone();
                    bitSet6.and(bitSet3);
                    if (bitSet6.equals(hGHyperEdge.getRightRelations())) {
                        bitSet5.set(n);
                        continue;
                    }
                    bitSet5.clear(n);
                    continue;
                }
                bitSet5.clear(n);
            }
            ((DPNode)object).setJoins(bitSet5);
            this.table.insert(bitSet3, (DPNode)object);
        } else if (lQJoinNode.getCost() < ((LQJoinNode)dPNode3.getRoot()).getCost()) {
            this.table.update(bitSet3, lQJoinNode);
        }
        if (!lQJoinNode.isOuterJoin() || lQJoinNode.isLeftOuterJoin() && lQJoinNode.isRightOuterJoin()) {
            object = lQJoinNode.clone();
            ((LQNode)object).setChild(0, lQJoinNode.getChild(1));
            ((LQNode)object).setChild(1, lQJoinNode.getChild(0));
            ((LQJoinNode)object).computeCost();
            if (((LQJoinNode)object).getCost() < lQJoinNode.getCost()) {
                this.table.update(bitSet3, (LQNode)object);
            }
        }
    }

    public boolean connected(BitSet bitSet, BitSet bitSet2) {
        return this.table.find(bitSet).getJoins().intersects(this.table.find(bitSet2).getJoins());
    }

    public LQJoinNode mergeJoinNodes(LQJoinNode lQJoinNode, LQJoinNode lQJoinNode2) {
        if (lQJoinNode.getCondition() == lQJoinNode2.getCondition()) {
            return lQJoinNode;
        }
        LQJoinNode lQJoinNode3 = new LQJoinNode();
        LQCondNode lQCondNode = new LQCondNode();
        lQCondNode.setType(111);
        lQCondNode.setContent("AND");
        lQCondNode.addChild(lQJoinNode.getCondition());
        lQCondNode.addChild(lQJoinNode2.getCondition());
        lQJoinNode.getCondition().setParent(lQCondNode);
        lQJoinNode2.getCondition().setParent(lQCondNode);
        lQCondNode.setParent(lQJoinNode3);
        lQJoinNode3.setCondition(lQCondNode);
        if (lQJoinNode.getFilterCondition() != null && lQJoinNode2.getFilterCondition() != null) {
            LQCondNode lQCondNode2 = new LQCondNode();
            lQCondNode2.setType(111);
            lQCondNode2.setContent("AND");
            lQCondNode2.addChild(lQJoinNode.getFilterCondition());
            lQCondNode2.addChild(lQJoinNode2.getFilterCondition());
            lQJoinNode3.setFilterCondition(lQCondNode2);
        } else if (lQJoinNode.getFilterCondition() != null) {
            lQJoinNode3.setFilterCondition(lQJoinNode.getFilterCondition());
        } else if (lQJoinNode2.getFilterCondition() != null) {
            lQJoinNode3.setFilterCondition(lQJoinNode2.getFilterCondition());
        }
        lQJoinNode3.setLeftTables(lQJoinNode.getLeftTables());
        lQJoinNode3.setRightTables(lQJoinNode.getRightTables());
        if (lQJoinNode.isComplexJoin || lQJoinNode2.isComplexJoin) {
            lQJoinNode3.isComplexJoin = true;
        }
        return lQJoinNode3;
    }
}

