/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.operators.Operator;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQCreateIndexNode
extends LQNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private ArrayList<LQExprNode> expressions;
    private ArrayList<String> orderings;
    private String tableName;
    private String indexName;
    private String indexType;
    private boolean unique;

    public LQCreateIndexNode() {
        this.type = 51;
    }

    public ArrayList<LQExprNode> getExpressions() {
        return this.expressions;
    }

    public ArrayList<String> getOrderings() {
        return this.orderings;
    }

    public void addField(LQExprNode lQExprNode, String string) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
            this.orderings = new ArrayList();
        }
        this.expressions.add(lQExprNode);
        this.orderings.add(string);
    }

    @Override
    public String toString() {
        return this.generateSQL();
    }

    @Override
    public String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("CREATE ");
        if (this.unique) {
            stringBuffer.append("UNIQUE ");
        }
        stringBuffer.append("INDEX ");
        stringBuffer.append(this.indexName);
        stringBuffer.append(" ON ");
        stringBuffer.append(this.tableName);
        if (this.expressions != null) {
            String string;
            int n;
            stringBuffer.append(" (");
            for (n = 0; n < this.expressions.size() - 1; ++n) {
                stringBuffer.append(this.expressions.get(n));
                stringBuffer.append(" ");
                string = this.orderings.get(n);
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.expressions.get(n));
            stringBuffer.append(" ");
            string = this.orderings.get(n);
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(')');
        }
        if (this.indexType != null) {
            stringBuffer.append(" USING ");
            stringBuffer.append(this.indexType);
        }
        return stringBuffer.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String string) {
        this.indexType = string;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    @Override
    public void computeCost() {
        this.setCost(0.0);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }
}

