/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import unity.annotation.AnnotatedSourceField;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.functions.Expression;
import unity.jdbc.UnityDriver;
import unity.mapping.DatabaseMapping;
import unity.operators.Operator;
import unity.operators.Projection;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQProjNode
extends LQNode {
    private static final long serialVersionUID = 1L;
    private ArrayList<LQExprNode> selList = new ArrayList();
    private boolean selectAll;

    public LQProjNode() {
        this.type = 1;
        this.selectAll = false;
    }

    public void addExpression(LQExprNode lQExprNode) {
        this.selList.add(lQExprNode);
    }

    public void setProjectionExpressions(ArrayList<LQExprNode> arrayList) {
        this.selList = arrayList;
    }

    public int getNumColumns() {
        return this.selList.size();
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean bl) {
        this.selectAll = bl;
    }

    public void addNoDupExpression(LQExprNode lQExprNode) {
        for (int i = 0; i < this.selList.size(); ++i) {
            LQExprNode lQExprNode2 = this.selList.get(i);
            if (lQExprNode2 == lQExprNode || lQExprNode2.getContent() == lQExprNode.getContent()) {
                return;
            }
            if (lQExprNode2.getType() != 100 || lQExprNode.getType() != 100) continue;
            Object object = lQExprNode2.getContent();
            Object object2 = lQExprNode.getContent();
            if (object == null || object2 == null) continue;
            if (object.toString().equals(object2.toString())) {
                return;
            }
            if (!(object instanceof GQFieldRef) || !(object2 instanceof GQFieldRef) || ((GQFieldRef)object).getField() != ((GQFieldRef)object2).getField()) continue;
            return;
        }
        this.selList.add(lQExprNode);
    }

    public boolean hasExpression(String string) {
        for (int i = 0; i < this.selList.size(); ++i) {
            LQExprNode lQExprNode = this.selList.get(i);
            String string2 = lQExprNode.generateSQL();
            if (string.indexOf(string2) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.selList == null || this.selList.size() == 0) {
            return "";
        }
        stringBuffer.append(this.selList.get(0).generateSQL());
        for (int i = 1; i < this.selList.size(); ++i) {
            LQExprNode lQExprNode = this.selList.get(i);
            stringBuffer.append(", ");
            stringBuffer.append(lQExprNode.generateSQL());
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("PROJECT: ");
        if (this.selList != null && this.selList.size() > 0) {
            stringBuffer.append(this.selList.get(0).toString());
            for (int i = 1; i < this.selList.size(); ++i) {
                LQExprNode lQExprNode = this.selList.get(i);
                stringBuffer.append(", ");
                stringBuffer.append(lQExprNode.toString());
            }
        }
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public Relation buildOutputRelation(GlobalQuery globalQuery) throws SQLException {
        Attribute[] attributeArray = new Attribute[this.selList.size()];
        for (int i = 0; i < this.selList.size(); ++i) {
            attributeArray[i] = this.selList.get(i).buildAttribute(globalQuery);
        }
        this.outputRelation = new Relation(attributeArray);
        return this.outputRelation;
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        Attribute[] attributeArray = new Attribute[this.selList.size()];
        LQNode lQNode = (LQNode)this.children.get(0);
        Relation relation = lQNode.getOutputRelation();
        if (relation == null) {
            if (lQNode.op != null && lQNode.op.getOutputRelation() != null) {
                relation = lQNode.op.getOutputRelation();
            } else {
                throw new SQLException(UnityDriver.i18n.getString("LQProjNode.NoInputRelation") + this);
            }
        }
        Expression[] expressionArray = new Expression[this.selList.size()];
        this.outputRelation = new Relation(attributeArray);
        Projection projection = new Projection(operatorArray[0], expressionArray, this.outputRelation, this);
        for (int i = 0; i < this.selList.size(); ++i) {
            attributeArray[i] = new Attribute();
            expressionArray[i] = this.selList.get(i).buildExpression(relation, attributeArray[i], globalQuery, subQuery, projection);
        }
        this.setOperator(projection);
        return projection;
    }

    public ArrayList<Object> getProjectedFields(ArrayList<Object> arrayList) {
        for (int i = 0; i < this.selList.size(); ++i) {
            LQExprNode lQExprNode = this.selList.get(i);
            if (lQExprNode.getType() == 100) {
                arrayList.add(lQExprNode.getContent());
                continue;
            }
            this.CollectIdentifierExpression(lQExprNode, arrayList);
        }
        return arrayList;
    }

    public void CollectIdentifierExpression(LQExprNode lQExprNode, ArrayList<Object> arrayList) {
        if (lQExprNode.getType() == 100) {
            arrayList.add(lQExprNode.getContent());
        } else {
            if (lQExprNode.getType() == 17) {
                arrayList.addAll(lQExprNode.getRequiredFields());
                return;
            }
            arrayList.addAll(lQExprNode.getRequiredFields());
        }
        for (int i = 0; i < lQExprNode.getNumChildren(); ++i) {
            LQNode lQNode = lQExprNode.getChild(i);
            this.CollectIdentifierExpression((LQExprNode)lQNode, arrayList);
        }
    }

    public ArrayList<LQExprNode> getExpressions() {
        return this.selList;
    }

    @Override
    public ArrayList<Object> getRequiredFields() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        return this.getProjectedFields(arrayList);
    }

    @Override
    public int numTuples() {
        if (this.getNumChildren() == 1) {
            return ((LQNode)this.children.get(0)).numTuples();
        }
        return -9;
    }

    @Override
    public int tupleSize() {
        int n = 0;
        for (int i = 0; i < this.selList.size(); ++i) {
            LQExprNode lQExprNode = this.selList.get(i);
            if (lQExprNode.getType() == 100) {
                Object object = lQExprNode.getContent();
                if (object != null && object instanceof GQFieldRef) {
                    GQFieldRef gQFieldRef = (GQFieldRef)lQExprNode.getContent();
                    int n2 = gQFieldRef.getField().getByteSize();
                    n += n2;
                    continue;
                }
                n += 10;
                continue;
            }
            n += 10;
        }
        return n;
    }

    @Override
    protected HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        if (DatabaseMapping.isSupported("#FIELD_LIST#", this.database, null) != 1) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        boolean bl2 = false;
        HashMap<String, AnnotatedSourceField> hashMap = new HashMap<String, AnnotatedSourceField>();
        for (int i = 0; i < this.selList.size(); ++i) {
            GQFieldRef gQFieldRef;
            AnnotatedSourceField annotatedSourceField;
            LQExprNode lQExprNode = this.selList.get(i);
            GQDatabaseRef gQDatabaseRef2 = lQExprNode.setDatabase(this.getDatabase(), bl);
            if (gQDatabaseRef2 != null) {
                hashSet.add(gQDatabaseRef2);
            }
            if (lQExprNode.type == 103) {
                lQExprNode = (LQExprNode)lQExprNode.getChild(0);
            }
            if (lQExprNode.type != 100 || !(lQExprNode.content instanceof GQFieldRef) || (annotatedSourceField = (gQFieldRef = (GQFieldRef)lQExprNode.content).getField()) == null) continue;
            String string = annotatedSourceField.getColumnName();
            if (hashMap.containsKey(string)) {
                bl2 = true;
                continue;
            }
            hashMap.put(string, annotatedSourceField);
        }
        if (bl2 && DatabaseMapping.isSupported("#DUPLICATE_FIELD#", this.database, null) != 1) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        return hashSet;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        this.cost = this.getChild(0).getCost() + (double)l * 1.0;
        this.rows = l;
    }
}

