/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Stack;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityStatement;
import unity.operators.BufferedResultSetScan;
import unity.operators.MemoryManager;
import unity.operators.Operator;
import unity.operators.ResultSetScan;
import unity.predicates.SelectionPredicate;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.HGHyperEdge;
import unity.query.HGNode;
import unity.query.HyperGraph;
import unity.query.LQCondNode;
import unity.query.LQExceptNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQIntersectNode;
import unity.query.LQJoinNode;
import unity.query.LQLimitNode;
import unity.query.LQNPNode;
import unity.query.LQNode;
import unity.query.LQOrderByNode;
import unity.query.LQProductNode;
import unity.query.LQProjNode;
import unity.query.LQSelNode;
import unity.query.LQSubQueryNode;
import unity.query.LQTree;
import unity.query.LQTreeConstants;
import unity.query.LQUnionNode;
import unity.query.LocalQuery;
import unity.query.SubQuery;

public class Optimizer
implements LQTreeConstants {
    private GlobalQuery globalQuery;
    private ArrayList<LQNode> localQueryRootNodes;
    private boolean localExecution = false;
    private UnityStatement statement;

    public Optimizer(GlobalQuery globalQuery, boolean bl, UnityStatement unityStatement) {
        this.globalQuery = globalQuery;
        this.localExecution = bl;
        this.statement = unityStatement;
    }

    public GlobalQuery optimize() throws SQLException {
        ArrayList<SubQuery> arrayList = this.globalQuery.getSubQueries();
        for (int i = 0; i < arrayList.size(); ++i) {
            SubQuery subQuery = arrayList.get(i);
            this.optimizeSubQuery(subQuery);
        }
        if (arrayList.size() == 1 && !this.localExecution) {
            this.globalQuery.setLocalQueries(arrayList.get(0).getLocalQueries());
            this.globalQuery.setLocalProcessing(arrayList.get(0).numLocalQueries() > 1);
        }
        if (UnityDriver.DEBUG) {
            System.out.println("\nStarting build execution tree.");
            this.globalQuery.getLogicalQueryTree().print();
        }
        this.buildExecutionTree();
        try {
            if (UnityDriver.DEBUG) {
                System.out.println("\n\nExecution tree:\n");
                Operator.printTree(this.globalQuery.getExecutionTree(), 0);
                System.out.println("\n\n");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new SQLException(UnityDriver.i18n.getString("Optimizer.InternalError") + nullPointerException.toString());
        }
        return this.globalQuery;
    }

    public GlobalQuery optimizeOne() throws SQLException {
        ArrayList<SubQuery> arrayList = this.globalQuery.getSubQueries();
        for (int i = 0; i < arrayList.size(); ++i) {
            SubQuery subQuery = arrayList.get(i);
            this.pushMultipleTableSelectsDown(subQuery);
            this.findLocalQueries(subQuery);
            this.postOptimization(subQuery);
        }
        return this.globalQuery;
    }

    public void optimizeSubQuery(SubQuery subQuery) throws SQLException {
        GQDatabaseRef gQDatabaseRef = subQuery.getFirstDatabaseRef();
        if (subQuery.getNumDBRef() > 1 || gQDatabaseRef != null && gQDatabaseRef.getDatabase() != null && gQDatabaseRef.getDatabase().getDatabaseProductName().contains("Mongo")) {
            block12: {
                if (UnityDriver.DEBUG) {
                    System.out.println("\n\n------BEGINNING OPTIMIZATION----- Starting tree:\n");
                    subQuery.getLogicalQueryTree().print();
                    System.out.println("\nStarting cost optimization.");
                }
                try {
                    this.costOptimization(subQuery);
                }
                catch (Exception exception) {
                    if (exception instanceof SQLException) {
                        throw new SQLException(exception);
                    }
                    if (!UnityDriver.DEBUG) break block12;
                    System.out.println("WARNING: Cost optimization failed.  Executing default plan.");
                }
            }
            if (UnityDriver.DEBUG) {
                System.out.println("Done cost optimization. Resulting tree:\n");
                subQuery.getLogicalQueryTree().print();
                System.out.println("\nStarting to push down multi-table selections.");
            }
            this.pushMultipleTableSelectsDown(subQuery);
            if (UnityDriver.DEBUG) {
                System.out.println("Done pushing down multi-table selections. Resulting tree:\n");
                subQuery.getLogicalQueryTree().print();
            }
        }
        if (UnityDriver.DEBUG) {
            System.out.println("\nStarted grouping.");
        }
        this.findLocalQueries(subQuery);
        if (UnityDriver.DEBUG) {
            System.out.println("Done grouping.");
            subQuery.getLogicalQueryTree().print();
            System.out.println("Done.");
        }
        if (subQuery.getNumDBRef() > 1 || this.localExecution || subQuery.getLogicalQueryTree().getRoot().getDatabase() == GQDatabaseRef.UNITYJDBC_DBREF) {
            if (UnityDriver.DEBUG) {
                System.out.println("\nStarted post-optimization.");
            }
            this.postOptimization(subQuery);
            if (UnityDriver.DEBUG) {
                System.out.println("Finished post-optimization.  Resulting tree:\n");
                subQuery.getLogicalQueryTree().print();
                System.out.println("\nSearching for distributed joins.");
            }
            this.findDistributedJoins(subQuery);
        }
    }

    private void heuristicOptimization(SubQuery subQuery) throws SQLException {
        LQTree lQTree = subQuery.getLogicalQueryTree();
        ArrayList<LQProjNode> arrayList = new ArrayList<LQProjNode>();
        ArrayList<LQSelNode> arrayList2 = new ArrayList<LQSelNode>();
        ArrayList<LQNode> arrayList3 = new ArrayList<LQNode>();
        ArrayList<LQJoinNode> arrayList4 = lQTree.getJoinList();
        this.findProjectSelect(lQTree.getRoot(), arrayList, arrayList2, arrayList3, new ArrayList<LQJoinNode>());
        for (int i = 0; i < arrayList2.size(); ++i) {
            LQCondNode lQCondNode;
            boolean bl;
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            Object object;
            LQSelNode lQSelNode = arrayList2.get(i);
            if (lQSelNode.getCondition().getType() == 129) {
                int n;
                object = lQSelNode.getCondition().getChild(0).getContent().toString();
                serializable3 = subQuery.getDBRef((String)(object = ((String)object).substring(1, ((String)object).length() - 1).toLowerCase()));
                if (serializable3 == null) {
                    throw new SQLException(UnityDriver.i18n.getString("Optimizer.ErrorDBNoTablesOrFields") + (String)object);
                }
                GQTableRef gQTableRef = subQuery.getTableRef((GQDatabaseRef)serializable3);
                serializable2 = lQSelNode.getChild(0);
                LQNode lQNode = lQSelNode.getParent();
                ((LQNode)serializable2).setParent(lQNode);
                lQNode.replaceChild(lQSelNode, (LQNode)serializable2);
                for (n = 0; n < arrayList3.size() && gQTableRef != (serializable = (GQTableRef)arrayList3.get(n).getContent()); ++n) {
                }
                serializable = arrayList3.get(n);
                lQNode = ((LQNode)serializable).getParent();
                lQNode.replaceChild((LQNode)serializable, lQSelNode);
                lQSelNode.setParent(lQNode);
                lQSelNode.removeChild(0);
                lQSelNode.addChild((LQNode)serializable);
                ((LQNode)serializable).setParent(lQSelNode);
                continue;
            }
            if (lQSelNode.bHavingCondition) continue;
            object = lQSelNode.getRequiredFields();
            serializable3 = new ArrayList();
            for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                serializable2 = ((GQFieldRef)((ArrayList)object).get(j)).getTable();
                if (((ArrayList)serializable3).contains(serializable2)) continue;
                ((ArrayList)serializable3).add(serializable2);
            }
            if (((ArrayList)object).size() == 0 && (bl = ((SelectionPredicate)(serializable2 = (lQCondNode = lQSelNode.getCondition()).buildSelectionPredicate(null, this.globalQuery, subQuery, null))).evaluate(null))) {
                LQNode lQNode = lQSelNode.getParent();
                serializable = lQSelNode.getChild(0);
                ((LQNode)serializable).setParent(lQNode);
                lQNode.setChild(0, (LQNode)serializable);
            }
            if (((ArrayList)serializable3).size() != 1 || subQuery.getOuterJoins() > 1) continue;
            LQNode lQNode = lQSelNode.getChild(0);
            serializable2 = lQSelNode.getParent();
            lQNode.setParent((LQNode)serializable2);
            ((LQNode)serializable2).replaceChild(lQSelNode, lQNode);
            this.addSelectionNodeAboveTable(lQSelNode, arrayList3);
            if (((ArrayList)object).size() > 1) continue;
            GQFieldRef gQFieldRef = (GQFieldRef)((ArrayList)object).get(0);
            for (int j = 0; j < arrayList4.size(); ++j) {
                serializable = arrayList4.get(j);
                LQNode lQNode2 = this.findEquatedFieldInJoinCondition(((LQJoinNode)serializable).getCondition(), gQFieldRef);
                if (lQNode2 == null) continue;
                LQSelNode lQSelNode2 = new LQSelNode();
                lQSelNode2.setCondition((LQCondNode)lQSelNode.getCondition().clone());
                this.replaceFieldInCondition(lQSelNode2.getCondition(), gQFieldRef, (GQFieldRef)lQNode2.getContent());
                this.addSelectionNodeAboveTable(lQSelNode2, arrayList3);
                ((LQJoinNode)serializable).setNoDistributedJoin(true);
                if (!UnityDriver.DEBUG) continue;
                System.out.println("Cloning a selection equated through a join.  New selection is: " + lQSelNode2.generateSQL());
            }
        }
    }

    private LQNode findEquatedFieldInJoinCondition(LQNode lQNode, GQFieldRef gQFieldRef) {
        LQNode lQNode2;
        if (lQNode == null) {
            return null;
        }
        if (lQNode instanceof LQExprNode && lQNode.getContent() == gQFieldRef && (lQNode2 = lQNode.getParent()) != null && lQNode2.getContent().equals("=")) {
            if (lQNode2.getChild(0) == lQNode) {
                return lQNode2.getChild(1);
            }
            return lQNode2.getChild(0);
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            LQNode lQNode3 = this.findEquatedFieldInJoinCondition(lQNode.getChild(i), gQFieldRef);
            if (lQNode3 == null) continue;
            return lQNode3;
        }
        return null;
    }

    private void replaceFieldInCondition(LQNode lQNode, GQFieldRef gQFieldRef, GQFieldRef gQFieldRef2) {
        if (lQNode == null) {
            return;
        }
        if (lQNode instanceof LQExprNode && lQNode.getContent() == gQFieldRef) {
            lQNode.setContent(gQFieldRef2);
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            this.replaceFieldInCondition(lQNode.getChild(i), gQFieldRef, gQFieldRef2);
        }
    }

    private void costOptimization(SubQuery subQuery) throws SQLException {
        int n;
        ArrayList[] arrayListArray;
        BitSet bitSet;
        LQNode lQNode;
        int n2;
        LQNode lQNode2 = subQuery.getLogicalQueryTree().getRoot();
        ArrayList<LQJoinNode> arrayList = new ArrayList<LQJoinNode>();
        ArrayList<GQTableRef> arrayList2 = new ArrayList<GQTableRef>();
        ArrayList<LQSelNode> arrayList3 = new ArrayList<LQSelNode>();
        ArrayList<LQProductNode> arrayList4 = new ArrayList<LQProductNode>();
        ArrayList<LQNode> arrayList5 = new ArrayList<LQNode>();
        ArrayList<LQNode> arrayList6 = new ArrayList<LQNode>();
        Optimizer.findTableSelJoinProd(subQuery.getLogicalQueryTree().getRoot(), arrayList2, arrayList3, arrayList, arrayList4);
        int n3 = arrayList4.size();
        if (subQuery.getOuterJoins() > 0 || n3 > 0) {
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                arrayList2.get(n2).setPosition(n2);
            }
            this.calcLRTables(subQuery.getLogicalQueryTree().getRoot(), arrayList2.size(), false);
        }
        if (subQuery.getOuterJoins() > 0) {
            BitSet bitSet2 = new BitSet(arrayList2.size());
            this.simplifyOuterJoins(lQNode2, bitSet2, arrayList2.size());
        }
        if (n3 > 0) {
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                lQNode = arrayList3.get(n2);
                if (!((LQSelNode)lQNode).getCondition().getContent().equals("=")) continue;
                bitSet = new BitSet(arrayList2.size());
                BitSet bitSet3 = new BitSet(arrayList2.size());
                this.findCondTables(((LQSelNode)lQNode).getCondition().getChild(0), bitSet, false);
                this.findCondTables(((LQSelNode)lQNode).getCondition().getChild(1), bitSet3, false);
                ((LQSelNode)lQNode).setLeftTables(bitSet);
                ((LQSelNode)lQNode).setRightTables(bitSet3);
                if (bitSet.cardinality() <= 0 || bitSet3.cardinality() <= 0 || bitSet.intersects(bitSet3)) continue;
                boolean bl = false;
                for (int i = 0; i < arrayList4.size(); ++i) {
                    LQProductNode lQProductNode = arrayList4.get(i);
                    if (lQProductNode.isReplaced()) continue;
                    BitSet bitSet4 = null;
                    BitSet bitSet5 = null;
                    if (lQProductNode.getLeftTables().intersects(bitSet)) {
                        bitSet4 = (BitSet)lQProductNode.getLeftTables().clone();
                        bitSet5 = (BitSet)lQProductNode.getRightTables().clone();
                    } else {
                        bitSet4 = (BitSet)lQProductNode.getRightTables().clone();
                        bitSet5 = (BitSet)lQProductNode.getLeftTables().clone();
                    }
                    bitSet4.and(bitSet);
                    if (!bitSet4.equals(bitSet)) continue;
                    bitSet5.and(bitSet3);
                    if (!bitSet5.equals(bitSet3)) continue;
                    lQProductNode.replace();
                    --n3;
                    LQJoinNode lQJoinNode = new LQJoinNode();
                    lQJoinNode.setLeftTables(lQProductNode.getLeftTables());
                    lQJoinNode.setRightTables(lQProductNode.getRightTables());
                    lQJoinNode.setCondition(((LQSelNode)lQNode).getCondition());
                    lQJoinNode.setComplex();
                    ((LQSelNode)lQNode).setComplexJoin(lQJoinNode);
                    lQJoinNode.setParent(lQProductNode.getParent());
                    lQJoinNode.addChild(lQProductNode.getChild(0));
                    lQJoinNode.addChild(lQProductNode.getChild(1));
                    lQProductNode.getChild(0).setParent(lQJoinNode);
                    lQProductNode.getChild(1).setParent(lQJoinNode);
                    if (lQJoinNode.getParent() != null) {
                        if (lQJoinNode.getParent().getChild(0) == lQProductNode) {
                            lQJoinNode.getParent().setChild(0, lQJoinNode);
                        } else {
                            lQJoinNode.getParent().setChild(1, lQJoinNode);
                        }
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList5.add(lQNode);
            }
            if (n3 > 0) {
                this.findHGRoots(arrayList4.get(0), arrayList6, false);
            } else {
                LQNode lQNode3 = lQNode2;
                while (lQNode3.getType() != 207) {
                    lQNode3 = lQNode3.getChild(0);
                }
                arrayList6.add(lQNode3);
            }
            arrayListArray = new ArrayList[arrayList6.size()];
            for (n2 = 0; n2 < arrayListArray.length; ++n2) {
                arrayListArray[n2] = new ArrayList();
            }
            block5: for (n2 = 0; n2 < arrayList5.size(); ++n2) {
                lQNode = (LQSelNode)arrayList5.get(n2);
                bitSet = (BitSet)((LQSelNode)lQNode).getLeftTables().clone();
                bitSet.or(((LQSelNode)lQNode).getRightTables());
                for (int i = 0; i < arrayList6.size(); ++i) {
                    if (arrayList6.get(i).getType() != 207) continue;
                    BitSet bitSet6 = (BitSet)((LQJoinNode)arrayList6.get(i)).getBelowTables().clone();
                    bitSet6.and(bitSet);
                    if (!bitSet6.equals(bitSet)) continue;
                    arrayListArray[i].add(lQNode);
                    continue block5;
                }
            }
        } else {
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                lQNode = arrayList3.get(n2);
                if (!((LQSelNode)lQNode).getCondition().getContent().equals("=")) continue;
                bitSet = new BitSet(arrayList2.size());
                BitSet bitSet7 = new BitSet(arrayList2.size());
                this.findCondTables(((LQSelNode)lQNode).getCondition().getChild(0), bitSet, false);
                this.findCondTables(((LQSelNode)lQNode).getCondition().getChild(1), bitSet7, false);
                ((LQSelNode)lQNode).setLeftTables(bitSet);
                ((LQSelNode)lQNode).setRightTables(bitSet7);
                if (bitSet.cardinality() <= 0 || bitSet7.cardinality() <= 0 || bitSet.intersects(bitSet7)) continue;
                arrayList5.add(lQNode);
            }
            arrayListArray = new ArrayList[]{arrayList5};
            if (arrayList.size() >= 1) {
                arrayList6.add(arrayList.get(0));
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            lQNode = arrayList.get(n2);
            if (!((LQJoinNode)lQNode).isComplex()) continue;
            ((LQJoinNode)lQNode).setComplex();
        }
        HyperGraph[] hyperGraphArray = new HyperGraph[arrayList6.size()];
        for (int i = 0; i < arrayList6.size(); ++i) {
            hyperGraphArray[i] = this.buildHyperGraph(arrayList6.get(i), arrayListArray[i]);
        }
        if (UnityDriver.DEBUG) {
            System.out.println("\n\n Done LQT simplification. Resulting tree:\n");
            subQuery.getLogicalQueryTree().print();
            System.out.println("\nStarting heuristic optimization.");
        }
        this.heuristicOptimization(subQuery);
        if (UnityDriver.DEBUG) {
            System.out.println("Done heuristic optimization.  Resulting tree:\n");
            subQuery.getLogicalQueryTree().print();
            System.out.println("Resuming cost optimization. ");
        }
        LQNode[] lQNodeArray = new LQNode[hyperGraphArray.length];
        for (n = 0; n < hyperGraphArray.length; ++n) {
            lQNodeArray[n] = hyperGraphArray[n].solve();
        }
        if (arrayList6.size() > 0) {
            if (hyperGraphArray[0].getRoot().getParent() == null) {
                subQuery.getLogicalQueryTree().setRoot(lQNodeArray[0]);
            }
            for (n = 0; n < arrayList3.size(); ++n) {
                LQSelNode lQSelNode = arrayList3.get(n);
                if (lQSelNode.getComplexJoin() == null) continue;
                LQNode lQNode4 = lQSelNode.getChild(0);
                lQNode4.setParent(lQSelNode.getParent());
                if (lQSelNode.getParent() == null) continue;
                lQSelNode.getParent().setChild(0, lQNode4);
            }
        }
    }

    private void splitAndCondition(LQCondNode lQCondNode, ArrayList<LQJoinNode> arrayList) {
        LQJoinNode lQJoinNode;
        LQCondNode lQCondNode2 = (LQCondNode)lQCondNode.getChild(0);
        LQCondNode lQCondNode3 = (LQCondNode)lQCondNode.getChild(1);
        if (lQCondNode2.getType() == 111) {
            this.splitAndCondition(lQCondNode2, arrayList);
        } else {
            lQJoinNode = new LQJoinNode();
            lQJoinNode.addChild(null);
            lQJoinNode.addChild(null);
            lQJoinNode.setCondition(lQCondNode2);
            arrayList.add(lQJoinNode);
        }
        if (lQCondNode3.getType() == 111) {
            this.splitAndCondition(lQCondNode3, arrayList);
        } else {
            lQJoinNode = new LQJoinNode();
            lQJoinNode.addChild(null);
            lQJoinNode.addChild(null);
            lQJoinNode.setCondition(lQCondNode3);
            arrayList.add(lQJoinNode);
        }
    }

    private void simplifyOuterJoins(LQNode lQNode, BitSet bitSet, int n) {
        if (lQNode instanceof LQSelNode) {
            bitSet.or(this.condNullRejects(((LQSelNode)lQNode).getCondition(), n));
        } else if (lQNode instanceof LQJoinNode) {
            LQJoinNode lQJoinNode = (LQJoinNode)lQNode;
            BitSet bitSet2 = (BitSet)lQJoinNode.getLeftTables().clone();
            BitSet bitSet3 = (BitSet)lQJoinNode.getRightTables().clone();
            BitSet bitSet4 = new BitSet(n);
            this.findCondTables(lQJoinNode.getCondition(), bitSet4, false);
            bitSet2.and(bitSet4);
            bitSet3.and(bitSet4);
            if (lQJoinNode.isLeftOuterJoin() && bitSet3.intersects(bitSet)) {
                lQJoinNode.setLeftOuterJoin(false);
            }
            if (lQJoinNode.isRightOuterJoin() && bitSet2.intersects(bitSet)) {
                lQJoinNode.setRightOuterJoin(false);
            }
            if (!lQJoinNode.isLeftOuterJoin()) {
                bitSet.or(bitSet2);
            }
            if (!lQJoinNode.isRightOuterJoin()) {
                bitSet.or(bitSet3);
            }
        }
        if (lQNode.getChild(0) != null) {
            this.simplifyOuterJoins(lQNode.getChild(0), (BitSet)bitSet.clone(), n);
        }
        if (lQNode.getChild(1) != null) {
            this.simplifyOuterJoins(lQNode.getChild(1), (BitSet)bitSet.clone(), n);
        }
    }

    private BitSet condNullRejects(LQCondNode lQCondNode, int n) {
        BitSet bitSet = new BitSet(n);
        if (lQCondNode.getType() == 111) {
            bitSet = this.condNullRejects((LQCondNode)lQCondNode.getChild(0), n);
            bitSet.or(this.condNullRejects((LQCondNode)lQCondNode.getChild(1), n));
        } else if (lQCondNode.getType() == 110) {
            bitSet = this.condNullRejects((LQCondNode)lQCondNode.getChild(0), n);
            bitSet.and(this.condNullRejects((LQCondNode)lQCondNode.getChild(1), n));
        } else if (lQCondNode.getContent().equals("IS")) {
            if (lQCondNode.getChild(0).getContent().equals("NULL") || lQCondNode.getChild(1).getContent().equals("NULL")) {
                return bitSet;
            }
        } else {
            this.findCondTables(lQCondNode, bitSet, false);
        }
        return bitSet;
    }

    private boolean findHGRoots(LQNode lQNode, ArrayList<LQNode> arrayList, boolean bl) {
        if (lQNode.getType() == 207) {
            if (((LQJoinNode)lQNode).isComplexJoin) {
                if (this.findHGRoots(lQNode.getChild(0), arrayList, true)) {
                    if (this.findHGRoots(lQNode.getChild(1), arrayList, true)) {
                        if (bl) {
                            lQNode.setHGRootCandidate();
                        } else {
                            arrayList.add(lQNode);
                        }
                        return true;
                    }
                    this.findHighestRootCandidates(lQNode.getChild(0), arrayList);
                    return false;
                }
                this.findHGRoots(lQNode.getChild(1), arrayList, false);
                return false;
            }
            if (bl) {
                lQNode.setHGRootCandidate();
            } else {
                arrayList.add(lQNode);
            }
            return true;
        }
        if (lQNode.getType() == 201) {
            this.findHGRoots(lQNode.getChild(0), arrayList, false);
            this.findHGRoots(lQNode.getChild(1), arrayList, false);
            return false;
        }
        if (bl) {
            lQNode.setHGRootCandidate();
        } else {
            arrayList.add(lQNode);
        }
        return false;
    }

    private void findHighestRootCandidates(LQNode lQNode, ArrayList<LQNode> arrayList) {
        if (lQNode.isHGRootCandidate) {
            arrayList.add(lQNode);
        } else if (lQNode.getType() == 207) {
            this.findHighestRootCandidates(lQNode.getChild(0), arrayList);
            this.findHighestRootCandidates(lQNode.getChild(1), arrayList);
        }
    }

    private HyperGraph buildHyperGraph(LQNode lQNode, ArrayList<LQSelNode> arrayList) {
        Object object;
        Object object2;
        Object object3;
        LQNode lQNode2;
        int n;
        int n2;
        ArrayList<LQJoinNode> arrayList2 = new ArrayList<LQJoinNode>();
        ArrayList<GQTableRef> arrayList3 = new ArrayList<GQTableRef>();
        ArrayList<LQProductNode> arrayList4 = new ArrayList<LQProductNode>();
        Optimizer.findTableSelJoinProd(lQNode, arrayList3, new ArrayList<LQSelNode>(), arrayList2, arrayList4);
        HyperGraph hyperGraph = new HyperGraph(arrayList3.size(), arrayList2, lQNode);
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            hyperGraph.insert(new HGNode(arrayList3.get(n2), arrayList3.size()));
        }
        n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            lQNode2 = arrayList2.get(n).getCondition();
            if (lQNode2.getType() == 111) {
                object3 = new ArrayList<LQJoinNode>();
                this.splitAndCondition((LQCondNode)lQNode2, (ArrayList<LQJoinNode>)object3);
                arrayList2.get(n).setSplitJoins((ArrayList<LQJoinNode>)object3);
                continue;
            }
            if (!arrayList2.get((int)n).isComplexJoin) continue;
            object3 = new BitSet(arrayList3.size());
            object2 = new BitSet(arrayList3.size());
            this.findCondTables(lQNode2.getChild(0), (BitSet)object3, true);
            this.findCondTables(lQNode2.getChild(1), (BitSet)object2, true);
            arrayList2.get(n).setLRTablesTES((BitSet)object3, (BitSet)object2);
        }
        this.calcLRTables(lQNode, arrayList3.size(), true);
        for (n = 0; n < arrayList.size(); ++n) {
            lQNode2 = arrayList.get(n);
            object3 = new LQJoinNode();
            ((LQJoinNode)object3).setCondition(((LQSelNode)lQNode2).getCondition());
            arrayList2.add((LQJoinNode)object3);
            ((LQSelNode)lQNode2).setComplexJoin((LQJoinNode)object3);
            object2 = new BitSet(arrayList3.size());
            object = new BitSet(arrayList3.size());
            this.findCondTables(((LQSelNode)lQNode2).getCondition().getChild(0), (BitSet)object2, true);
            this.findCondTables(((LQSelNode)lQNode2).getCondition().getChild(1), (BitSet)object, true);
            ((LQJoinNode)object3).setLRTablesTES((BitSet)object2, (BitSet)object);
            ((LQJoinNode)object3).setLeftTables(((LQJoinNode)lQNode).getLeftTables());
            ((LQJoinNode)object3).setRightTables(((LQJoinNode)lQNode).getRightTables());
            ((LQJoinNode)object3).setComplex();
            ((LQJoinNode)object3).setMayConflict(true);
        }
        if (this.containsOuterJoins(arrayList2)) {
            this.calcTES(lQNode, arrayList, arrayList3.size());
            hyperGraph.updateJoins();
            for (n = 0; n < arrayList2.size(); ++n) {
                lQNode2 = arrayList2.get(n);
                if (((LQJoinNode)lQNode2).isComplexJoin && !((LQJoinNode)lQNode2).getTES().equals(((LQJoinNode)lQNode2).getRequiredTables())) {
                    if (((LQJoinNode)lQNode2).getTES().equals(((LQJoinNode)lQNode2).getRequiredTables())) {
                        ((LQJoinNode)lQNode2).getSelNode().setComplexJoin(null);
                        arrayList2.set(n, null);
                        continue;
                    }
                    hyperGraph.addHyperEdge(new HGHyperEdge(((LQJoinNode)lQNode2).getLCondTables(), ((LQJoinNode)lQNode2).getRCondTables(), n));
                    hyperGraph.setAllConnected(false);
                    continue;
                }
                object3 = (BitSet)((LQJoinNode)lQNode2).getLeftTables().clone();
                ((BitSet)object3).and(((LQJoinNode)lQNode2).getTES());
                object2 = (BitSet)((LQJoinNode)lQNode2).getRightTables().clone();
                ((BitSet)object2).and(((LQJoinNode)lQNode2).getTES());
                if (((BitSet)object3).cardinality() > 1 || ((BitSet)object2).cardinality() > 1) {
                    object = new HGHyperEdge((BitSet)object3, (BitSet)object2, n);
                    ((HGHyperEdge)object).setLeftConnected();
                    ((HGHyperEdge)object).setRightConnected();
                    hyperGraph.addHyperEdge((HGHyperEdge)object);
                    continue;
                }
                object = hyperGraph.getNodeAt(((BitSet)object3).nextSetBit(0));
                HGNode hGNode = hyperGraph.getNodeAt(((BitSet)object2).nextSetBit(0));
                hyperGraph.addEdge((HGNode)object, hGNode, n);
            }
        } else {
            if (arrayList.size() > 0) {
                hyperGraph.setAllConnected(false);
            }
            hyperGraph.updateJoins();
            for (n = 0; n < arrayList2.size(); ++n) {
                if (arrayList2.get((int)n).isComplexJoin) {
                    hyperGraph.addHyperEdge(new HGHyperEdge(arrayList2.get(n).getLCondTables(), arrayList2.get(n).getRCondTables(), n));
                    continue;
                }
                lQNode2 = arrayList2.get(n).getCondition();
                object3 = lQNode2.getChild(0).getContent();
                object2 = lQNode2.getChild(1).getContent();
                if (!(object3 instanceof GQFieldRef) || !(object2 instanceof GQFieldRef)) continue;
                object = ((GQFieldRef)lQNode2.getChild(0).getContent()).getTable().getHGNode();
                HGNode hGNode = ((GQFieldRef)lQNode2.getChild(1).getContent()).getTable().getHGNode();
                hyperGraph.addEdge((HGNode)object, hGNode, n);
            }
        }
        hyperGraph.findAndRemoveUnconnectedHypEdges();
        hyperGraph.removeConflictingHyperEdges();
        hyperGraph.updateComplexJoins();
        return hyperGraph;
    }

    private boolean containsOuterJoins(ArrayList<LQJoinNode> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).isOuterJoin()) continue;
            return true;
        }
        return false;
    }

    private ArrayList<LQJoinNode> calcTES(LQNode lQNode, ArrayList<LQSelNode> arrayList, int n) {
        int n2;
        Serializable serializable;
        ArrayList<Object> arrayList2 = new ArrayList();
        ArrayList<Object> arrayList3 = new ArrayList();
        if (lQNode.getChild(0) != null) {
            arrayList2 = this.calcTES(lQNode.getChild(0), null, n);
        }
        if (lQNode.getChild(1) != null) {
            arrayList3 = this.calcTES(lQNode.getChild(1), null, n);
        }
        LQJoinNode lQJoinNode = null;
        ArrayList<LQJoinNode> arrayList4 = null;
        BitSet bitSet = new BitSet(n);
        if (lQNode instanceof LQJoinNode) {
            lQJoinNode = (LQJoinNode)lQNode;
            arrayList4 = lQJoinNode.getSplitJoins();
            if (arrayList4 == null) {
                this.findCondTables(lQJoinNode.getCondition(), bitSet, true);
            } else {
                serializable = new BitSet(n);
                for (int i = 0; i < arrayList4.size(); ++i) {
                    this.findCondTables(arrayList4.get(i).getCondition(), (BitSet)serializable, true);
                    arrayList4.get(i).setReqTablesTES((BitSet)serializable);
                    bitSet.or((BitSet)serializable);
                    serializable = new BitSet(n);
                }
            }
            lQJoinNode.setReqTablesTES((BitSet)bitSet.clone());
        } else if (lQNode instanceof LQSelNode && (lQJoinNode = ((LQSelNode)lQNode).getComplexJoin()) != null) {
            bitSet = (BitSet)lQJoinNode.getTES().clone();
        }
        serializable = lQNode.getChild(0);
        LQNode lQNode2 = lQNode.getChild(1);
        if (serializable != null) {
            if (serializable instanceof LQJoinNode) {
                arrayList2.add((LQJoinNode)serializable);
            } else if (serializable instanceof LQSelNode && (lQJoinNode = ((LQSelNode)serializable).getComplexJoin()) != null) {
                arrayList2.add((LQJoinNode)serializable);
            }
        }
        if (lQNode2 != null) {
            if (lQNode2 instanceof LQJoinNode) {
                arrayList3.add((LQJoinNode)lQNode2);
            } else if (serializable instanceof LQSelNode && (lQJoinNode = ((LQSelNode)lQNode2).getComplexJoin()) != null) {
                arrayList3.add((LQJoinNode)lQNode2);
            }
        }
        if (lQJoinNode != null) {
            LQJoinNode lQJoinNode2;
            int n3;
            BitSet bitSet2;
            LQJoinNode lQJoinNode3;
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                lQJoinNode3 = (LQJoinNode)arrayList2.get(n2);
                if (!this.oc(lQJoinNode3, lQJoinNode)) continue;
                bitSet2 = new BitSet(n);
                this.lrTables(lQJoinNode, lQJoinNode3, bitSet2, 0);
                if (!bitSet.intersects(bitSet2)) continue;
                lQJoinNode.addTES(lQJoinNode3.getTES());
                if (arrayList4 != null) {
                    for (n3 = 0; n3 < arrayList4.size(); ++n3) {
                        lQJoinNode2 = arrayList4.get(n3);
                        if (!lQJoinNode2.getRequiredTables().intersects(bitSet2)) continue;
                        lQJoinNode2.addTES(lQJoinNode3.getTES());
                    }
                }
                if (arrayList == null) continue;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    lQJoinNode2 = arrayList.get(n3).getComplexJoin();
                    if (!lQJoinNode2.getRequiredTables().intersects(bitSet2)) continue;
                    lQJoinNode2.addTES(lQJoinNode3.getTES());
                }
            }
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                lQJoinNode3 = (LQJoinNode)arrayList3.get(n2);
                arrayList2.add(lQJoinNode3);
                if (!this.oc(lQJoinNode, lQJoinNode3)) continue;
                bitSet2 = new BitSet(n);
                this.lrTables(lQJoinNode, lQJoinNode3, bitSet2, 1);
                if (!bitSet.intersects(bitSet2)) continue;
                lQJoinNode.addTES(lQJoinNode3.getTES());
                if (arrayList4 != null) {
                    for (n3 = 0; n3 < arrayList4.size(); ++n3) {
                        lQJoinNode2 = arrayList4.get(n3);
                        if (!lQJoinNode2.getRequiredTables().intersects(bitSet2)) continue;
                        lQJoinNode2.addTES(lQJoinNode3.getTES());
                    }
                }
                if (arrayList == null) continue;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    lQJoinNode2 = arrayList.get(n3).getComplexJoin();
                    if (!lQJoinNode2.getRequiredTables().intersects(bitSet2)) continue;
                    lQJoinNode2.addTES(lQJoinNode3.getTES());
                }
            }
        }
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            arrayList2.add(arrayList3.get(n2));
        }
        return arrayList2;
    }

    private BitSet calcLRTables(LQNode lQNode, int n, boolean bl) {
        BitSet bitSet = new BitSet(n);
        BitSet bitSet2 = new BitSet(n);
        BitSet bitSet3 = new BitSet(n);
        if (lQNode.getChild(0) != null) {
            bitSet = this.calcLRTables(lQNode.getChild(0), n, bl);
        }
        if (lQNode.getChild(1) != null) {
            bitSet2 = this.calcLRTables(lQNode.getChild(1), n, bl);
        }
        LQJoinNode lQJoinNode = null;
        if (lQNode instanceof LQJoinNode) {
            lQJoinNode = (LQJoinNode)lQNode;
        } else if (lQNode instanceof LQSelNode) {
            lQJoinNode = ((LQSelNode)lQNode).getComplexJoin();
        } else if (lQNode instanceof LQProductNode && !bl) {
            ((LQProductNode)lQNode).setLeftTables(bitSet);
            ((LQProductNode)lQNode).setRightTables(bitSet2);
        }
        if (lQJoinNode != null) {
            lQJoinNode.setLeftTables(bitSet);
            lQJoinNode.setRightTables(bitSet2);
            ArrayList<LQJoinNode> arrayList = lQJoinNode.getSplitJoins();
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    LQJoinNode lQJoinNode2 = arrayList.get(i);
                    lQJoinNode2.setLeftTables(bitSet);
                    lQJoinNode2.setRightTables(bitSet2);
                }
            }
        }
        if (lQNode.getType() == 6) {
            if (bl) {
                bitSet3.set(((GQTableRef)lQNode.getContent()).getHGNode().getPosition());
            } else {
                bitSet3.set(((GQTableRef)lQNode.getContent()).getPosition());
            }
        } else {
            bitSet3 = (BitSet)bitSet.clone();
            bitSet3.or(bitSet2);
        }
        return bitSet3;
    }

    private boolean oc(LQJoinNode lQJoinNode, LQJoinNode lQJoinNode2) {
        boolean bl = !lQJoinNode.isOuterJoin() && lQJoinNode2.isRightOuterJoin();
        boolean bl2 = lQJoinNode.isLeftOuterJoin() && !lQJoinNode.isRightOuterJoin() && lQJoinNode2.isLeftOuterJoin() && !lQJoinNode2.isRightOuterJoin();
        boolean bl3 = lQJoinNode.isLeftOuterJoin() && lQJoinNode.isRightOuterJoin() && lQJoinNode2.isLeftOuterJoin();
        return bl || lQJoinNode.isOuterJoin() && !bl2 && !bl3;
    }

    private void pushMultipleTableSelectsDown(SubQuery subQuery) {
        LQTree lQTree = subQuery.getLogicalQueryTree();
        ArrayList<LQSelNode> arrayList = new ArrayList<LQSelNode>();
        ArrayList<LQNode> arrayList2 = new ArrayList<LQNode>();
        this.findProjectSelect(lQTree.getRoot(), new ArrayList<LQProjNode>(), arrayList, arrayList2, new ArrayList<LQJoinNode>());
        for (int i = 0; i < arrayList.size(); ++i) {
            Serializable serializable;
            Serializable serializable2;
            LQSelNode lQSelNode = arrayList.get(i);
            ArrayList<Object> arrayList3 = lQSelNode.getRequiredFields();
            ArrayList<GQTableRef> arrayList4 = new ArrayList<GQTableRef>();
            for (int j = 0; j < arrayList3.size(); ++j) {
                GQTableRef gQTableRef = ((GQFieldRef)arrayList3.get(j)).getTable();
                if (arrayList4.contains(gQTableRef)) continue;
                arrayList4.add(gQTableRef);
            }
            if (arrayList4.size() <= 1) continue;
            ArrayList[] arrayListArray = new ArrayList[arrayList4.size()];
            boolean bl = true;
            for (int j = 0; j < arrayList4.size(); ++j) {
                int n;
                for (n = 0; n < arrayList2.size() && (serializable2 = (GQTableRef)arrayList4.get(j)) != (serializable = (GQTableRef)arrayList2.get(n).getContent()); ++n) {
                }
                if (n >= arrayList2.size()) {
                    bl = false;
                    break;
                }
                serializable2 = new ArrayList();
                serializable = arrayList2.get(n);
                ((ArrayList)serializable2).add(serializable);
                while (((LQNode)serializable).getParent() != null) {
                    serializable = ((LQNode)serializable).getParent();
                    ((ArrayList)serializable2).add(0, serializable);
                }
                arrayListArray[j] = serializable2;
            }
            if (!bl) continue;
            LQNode lQNode = null;
            block5: for (int j = 0; j < arrayListArray[0].size(); ++j) {
                serializable = (LQNode)arrayListArray[0].get(j);
                for (int k = 1; k < arrayListArray.length; ++k) {
                    if (arrayListArray[k].get(j) == serializable) continue;
                    lQNode = (LQNode)arrayListArray[0].get(j - 1);
                    j = arrayListArray[0].size();
                    continue block5;
                }
            }
            serializable2 = lQSelNode.getChild(0);
            if (lQNode.getParent() == lQSelNode) continue;
            serializable = lQSelNode.getParent();
            ((LQNode)serializable2).setParent((LQNode)serializable);
            ((LQNode)serializable).replaceChild(lQSelNode, (LQNode)serializable2);
            LQNode lQNode2 = lQNode.getParent();
            lQNode2.replaceChild(lQNode, lQSelNode);
            lQSelNode.setParent(lQNode2);
            lQSelNode.removeChild(0);
            lQSelNode.addChild(lQNode);
            lQNode.setParent(lQSelNode);
        }
    }

    private void findProjectSelect(LQNode lQNode, ArrayList<LQProjNode> arrayList, ArrayList<LQSelNode> arrayList2, ArrayList<LQNode> arrayList3, ArrayList<LQJoinNode> arrayList4) {
        if (lQNode == null) {
            return;
        }
        if (lQNode.getType() == 1) {
            arrayList.add((LQProjNode)lQNode);
        } else if (lQNode.getType() == 2) {
            arrayList2.add((LQSelNode)lQNode);
        } else if (lQNode.getType() == 6) {
            arrayList3.add(lQNode);
        } else if (lQNode.getType() == 17) {
            arrayList3.add(lQNode);
        } else if (lQNode.getType() == 207) {
            arrayList4.add((LQJoinNode)lQNode);
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            this.findProjectSelect(lQNode.getChild(i), arrayList, arrayList2, arrayList3, arrayList4);
        }
    }

    public static void findTableSelJoinProd(LQNode lQNode, ArrayList<GQTableRef> arrayList, ArrayList<LQSelNode> arrayList2, ArrayList<LQJoinNode> arrayList3, ArrayList<LQProductNode> arrayList4) {
        if (lQNode == null) {
            return;
        }
        if (lQNode.getType() == 6) {
            arrayList.add((GQTableRef)lQNode.getContent());
        } else if (lQNode.getType() == 17) {
            arrayList.add((GQTableRef)lQNode.getContent());
        } else if (lQNode.getType() == 2) {
            arrayList2.add((LQSelNode)lQNode);
        } else if (lQNode.getType() == 207) {
            arrayList3.add((LQJoinNode)lQNode);
        } else if (lQNode instanceof LQProductNode) {
            arrayList4.add((LQProductNode)lQNode);
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            Optimizer.findTableSelJoinProd(lQNode.getChild(i), arrayList, arrayList2, arrayList3, arrayList4);
        }
    }

    public static void findTables(LQNode lQNode, ArrayList<GQTableRef> arrayList) {
        Object object;
        if (lQNode == null) {
            return;
        }
        if (lQNode.getType() == 100) {
            GQTableRef gQTableRef;
            object = lQNode.getContent();
            if (object != null && object instanceof GQFieldRef && !arrayList.contains(gQTableRef = ((GQFieldRef)object).getTable())) {
                arrayList.add(gQTableRef);
            }
        } else if (lQNode.getType() == 6 && !arrayList.contains(object = (GQTableRef)lQNode.getContent())) {
            arrayList.add((GQTableRef)object);
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            Optimizer.findTables(lQNode.getChild(i), arrayList);
        }
    }

    private void findCondTables(LQNode lQNode, BitSet bitSet, boolean bl) {
        if (lQNode == null) {
            return;
        }
        if (lQNode.getType() == 100) {
            if (bl) {
                bitSet.set(((GQFieldRef)lQNode.getContent()).getTable().getHGNode().getPosition());
            } else {
                bitSet.set(((GQFieldRef)lQNode.getContent()).getTable().getPosition());
            }
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            this.findCondTables(lQNode.getChild(i), bitSet, bl);
        }
    }

    private void lrTables(LQJoinNode lQJoinNode, LQNode lQNode, BitSet bitSet, int n) {
        LQNode lQNode2;
        if (!lQJoinNode.isOuterJoin() || lQJoinNode.isLeftOuterJoin && lQJoinNode.isRightOuterJoin()) {
            bitSet.or(lQJoinNode.getLeftTables());
            bitSet.or(lQJoinNode.getRightTables());
        } else if (n == 0) {
            bitSet.or(lQJoinNode.getLeftTables());
        } else {
            bitSet.or(lQJoinNode.getRightTables());
        }
        if (lQNode2 != lQNode) {
            for (lQNode2 = lQJoinNode.getParent(); lQNode2 != null && !(lQNode2 instanceof LQJoinNode); lQNode2 = lQNode2.getParent()) {
            }
            if (lQNode2 != null && lQNode2 != lQNode) {
                this.lrTables((LQJoinNode)lQNode2, lQNode, bitSet, n);
            }
        }
    }

    public void findLocalQueries(SubQuery subQuery) {
        this.localQueryRootNodes = new ArrayList();
        LQTree lQTree = subQuery.getLogicalQueryTree();
        LQNode lQNode = lQTree.getRoot();
        if (lQNode instanceof LQNPNode) {
            this.localQueryRootNodes.add(lQNode);
            subQuery.setLocalQueryNodes(this.localQueryRootNodes);
            return;
        }
        lQNode.setDatabase(null, this.localExecution);
        this.findLQ(lQNode, this.localQueryRootNodes);
        if (UnityDriver.DEBUG) {
            System.out.println("Number of roots: " + this.localQueryRootNodes.size());
            for (int i = 0; i < this.localQueryRootNodes.size(); ++i) {
                System.out.println("Root " + i + ": " + this.localQueryRootNodes.get(i));
            }
        }
        subQuery.setLocalQueryNodes(this.localQueryRootNodes);
    }

    private void findLQ(LQNode lQNode, ArrayList<LQNode> arrayList) {
        if (lQNode == null) {
            return;
        }
        if (lQNode.getDatabase() != GQDatabaseRef.UNITYJDBC_DBREF && lQNode.getDatabase() != null) {
            arrayList.add(lQNode);
            return;
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            this.findLQ(lQNode.getChild(i), arrayList);
        }
    }

    private void postOptimization(SubQuery subQuery) {
        LQTree.validateTree(subQuery.getLogicalQueryTree().getRoot());
        for (int i = 0; i < this.localQueryRootNodes.size(); ++i) {
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            Serializable serializable4;
            Serializable serializable5;
            Serializable serializable6;
            LQNode lQNode = this.localQueryRootNodes.get(i);
            if (UnityDriver.DEBUG) {
                System.out.println("Processing local root: " + lQNode);
            }
            if (lQNode instanceof LQGroupByNode) {
                serializable6 = (LQGroupByNode)lQNode;
                ArrayList<LQExprNode> arrayList = ((LQGroupByNode)serializable6).getGroupList();
                serializable5 = ((LQGroupByNode)serializable6).getFunctionList();
                serializable4 = new ArrayList<LQExprNode>();
                ((ArrayList)serializable4).addAll(arrayList);
                ((ArrayList)serializable4).addAll(serializable5);
                serializable3 = new LQProjNode();
                ((LQProjNode)serializable3).setProjectionExpressions((ArrayList<LQExprNode>)serializable4);
                serializable2 = ((LQNode)serializable6).getChild();
                ((LQNode)serializable2).setParent((LQNode)serializable3);
                ((LQNode)serializable3).addChild((LQNode)serializable2);
                ((LQNode)serializable6).setChild(0, (LQNode)serializable3);
                ((LQNode)serializable3).setParent((LQNode)serializable6);
                if (UnityDriver.DEBUG) {
                    subQuery.getLogicalQueryTree().print();
                }
            }
            serializable6 = new ArrayList();
            this.findProjectSelect(lQNode, (ArrayList<LQProjNode>)serializable6, new ArrayList<LQSelNode>(), new ArrayList<LQNode>(), new ArrayList<LQJoinNode>());
            if (UnityDriver.DEBUG) {
                System.out.println("PROJECT LIST: " + serializable6);
            }
            for (int j = 0; j < ((ArrayList)serializable6).size(); ++j) {
                serializable5 = (LQProjNode)((ArrayList)serializable6).get(j);
                if (((LQProjNode)serializable5).getNumColumns() != 0) continue;
                serializable4 = new LQExprNode();
                ((LQNode)serializable4).setContent("*");
                ((LQNode)serializable4).setType(127);
                ((LQProjNode)serializable5).addExpression((LQExprNode)serializable4);
            }
            if (((ArrayList)serializable6).size() == 0) {
                LQNode lQNode2;
                for (lQNode2 = lQNode; lQNode2 != null && !(lQNode2 instanceof LQProjNode); lQNode2 = lQNode2.getParent()) {
                }
                if (lQNode2 == null) continue;
                serializable5 = lQNode.getParent();
                serializable4 = lQNode2.getParent();
                serializable3 = lQNode2.getChild(0);
                ((LQNode)serializable3).setParent((LQNode)serializable4);
                if (serializable4 != null) {
                    ((LQNode)serializable4).replaceChild(lQNode2, (LQNode)serializable3);
                }
                ((LQNode)serializable5).replaceChild(lQNode, lQNode2);
                lQNode2.setParent((LQNode)serializable5);
                lQNode.setParent(lQNode2);
                lQNode2.replaceChild((LQNode)serializable3, lQNode);
                this.localQueryRootNodes.set(i, lQNode2);
                lQNode2.setDatabase(lQNode.getDatabase());
                continue;
            }
            if (((ArrayList)serializable6).size() <= 1) continue;
            LQNode lQNode3 = (LQNode)((ArrayList)serializable6).get(0);
            boolean bl = true;
            for (int j = 1; j < ((ArrayList)serializable6).size(); ++j) {
                if (LQNode.isDescendant(lQNode3, (LQNode)((ArrayList)serializable6).get(j))) continue;
                bl = false;
                break;
            }
            if (bl) {
                return;
            }
            serializable4 = new LQProjNode();
            serializable2 = new ArrayList();
            for (LQNode lQNode4 = lQNode.getParent(); lQNode4 != null; lQNode4 = lQNode4.getParent()) {
                serializable = lQNode4.getRequiredFields();
                ((ArrayList)serializable2).addAll(serializable);
            }
            for (int j = 0; j < ((ArrayList)serializable6).size(); ++j) {
                LQProjNode lQProjNode = (LQProjNode)((ArrayList)serializable6).get(j);
                serializable3 = lQProjNode.getExpressions();
                for (int k = 0; k < ((ArrayList)serializable3).size(); ++k) {
                    LQExprNode lQExprNode = (LQExprNode)((ArrayList)serializable3).get(k);
                    if (lQExprNode.getType() == 100) {
                        GQFieldRef gQFieldRef = (GQFieldRef)lQExprNode.getContent();
                        if (!((ArrayList)serializable2).contains(gQFieldRef)) continue;
                        ((LQProjNode)serializable4).addExpression(lQExprNode);
                        continue;
                    }
                    ((LQProjNode)serializable4).addExpression(lQExprNode);
                }
                LQNode lQNode5 = lQProjNode.getParent();
                if (lQNode5 != null) {
                    lQNode5.replaceChild(lQProjNode, lQProjNode.getChild(0));
                    lQProjNode.getChild(0).setParent(lQNode5);
                    continue;
                }
                ((LQNode)serializable4).addChild(lQProjNode.getChild(0));
                lQProjNode.getChild(0).setParent((LQNode)serializable4);
            }
            serializable = lQNode.getParent();
            ((LQNode)serializable4).setParent((LQNode)serializable);
            if (((LQNode)serializable4).getNumChildren() == 0) {
                ((LQNode)serializable4).addChild(lQNode);
            }
            if (serializable != null) {
                ((LQNode)serializable).replaceChild(lQNode, (LQNode)serializable4);
            } else {
                subQuery.getLogicalQueryTree().setRoot((LQNode)serializable4);
            }
            this.localQueryRootNodes.set(i, (LQNode)serializable4);
            ((LQNode)serializable4).setReference(lQNode.getReference());
            ((LQNode)serializable4).setDatabase(lQNode.getDatabase());
        }
    }

    private void findDistributedJoins(SubQuery subQuery) {
        UnityConnection unityConnection = this.globalQuery.getConnection();
        if (unityConnection == null) {
            return;
        }
        String string = unityConnection.getProperty("pushdownjoin");
        if (string == null || string.equals("") || string.equals("0")) {
            if (UnityDriver.DEBUG) {
                System.out.println("Push-down joins disabled.");
            }
            return;
        }
        int n = Integer.parseInt(string);
        boolean bl = true;
        LQTree lQTree = subQuery.getLogicalQueryTree();
        ArrayList<LQJoinNode> arrayList = new ArrayList<LQJoinNode>();
        this.findProjectSelect(lQTree.getRoot(), new ArrayList<LQProjNode>(), new ArrayList<LQSelNode>(), new ArrayList<LQNode>(), arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            double d;
            int n2;
            int n3;
            LQJoinNode lQJoinNode = arrayList.get(i);
            if (lQJoinNode.getNoDistributedJoin() || lQJoinNode.isOuterJoin() || lQJoinNode.isComplexJoin) {
                if (!UnityDriver.DEBUG) continue;
                System.out.println("Flag set to avoid distributed join for node: " + lQJoinNode);
                continue;
            }
            ArrayList<LQNode> arrayList2 = lQJoinNode.getChildren();
            LQNode lQNode = arrayList2.get(0);
            LQNode lQNode2 = arrayList2.get(1);
            GQDatabaseRef gQDatabaseRef = lQNode.getDatabase();
            GQDatabaseRef gQDatabaseRef2 = lQNode2.getDatabase();
            int n4 = lQNode.numTuples();
            int n5 = lQNode2.numTuples();
            ArrayList<LQNode> arrayList3 = this.globalQuery.getLocalQueryRootNodes();
            if (lQJoinNode.getDatabase() != GQDatabaseRef.UNITYJDBC_DBREF || gQDatabaseRef == GQDatabaseRef.UNITYJDBC_DBREF && gQDatabaseRef2 == GQDatabaseRef.UNITYJDBC_DBREF) continue;
            boolean bl2 = bl = n4 <= n5;
            if (bl && gQDatabaseRef == GQDatabaseRef.UNITYJDBC_DBREF) continue;
            if (bl) {
                n3 = n4;
                n2 = n5;
                d = 1.0 * (double)n4 / (double)n5;
            } else {
                n3 = n5;
                n2 = n4;
                d = 1.0 * (double)n5 / (double)n4;
            }
            if (bl && !arrayList3.contains(lQNode2) || !bl && !arrayList3.contains(lQNode)) continue;
            if (UnityDriver.DEBUG) {
                System.out.println("Distributed join info: Left tuples: " + n4 + " Right tuples: " + n5 + " Ratio: " + d);
            }
            if (!(d < 0.05) || n2 <= 1000) continue;
            if (n3 < 100 && n % 2 == 1) {
                lQJoinNode.setJoinType(302);
            } else {
                if (n / 2 < 1) continue;
                lQJoinNode.setJoinType(306);
            }
            if (UnityDriver.DEBUG) {
                System.out.println(" Join type is changed to Distributed Join.");
            }
            if (bl) continue;
            lQJoinNode.setSwap();
        }
    }

    private GQTableRef getTableRef(LQSelNode lQSelNode) {
        ArrayList<Object> arrayList = lQSelNode.getRequiredFields();
        return ((GQFieldRef)arrayList.get(0)).getTable();
    }

    private void addSelectionNodeAboveTable(LQSelNode lQSelNode, ArrayList<LQNode> arrayList) {
        Serializable serializable;
        int n;
        GQTableRef gQTableRef = this.getTableRef(lQSelNode);
        for (n = 0; n < arrayList.size() && gQTableRef != (serializable = (GQTableRef)arrayList.get(n).getContent()); ++n) {
        }
        serializable = arrayList.get(n);
        LQNode lQNode = ((LQNode)serializable).getParent();
        lQNode.replaceChild((LQNode)serializable, lQSelNode);
        lQSelNode.setParent(lQNode);
        lQSelNode.removeChild(0);
        lQSelNode.addChild((LQNode)serializable);
        ((LQNode)serializable).setParent(lQSelNode);
    }

    public void buildExecutionTree() throws SQLException {
        ArrayList<LocalQuery> arrayList = new ArrayList<LocalQuery>();
        LQNode lQNode = this.globalQuery.getLogicalQueryTree().getRoot();
        ArrayList<LQNode> arrayList2 = this.globalQuery.getLocalQueryRootNodes();
        this.globalQuery.setLocalQueries(arrayList);
        if (this.globalQuery.getLocalProcessing()) {
            MemoryManager.allocateQueryMemory(lQNode, arrayList2, this.statement);
        }
        this.globalQuery.setExecutionTree(Optimizer.buildExecTree(lQNode, arrayList, arrayList2, this.globalQuery, null));
    }

    public static Operator buildExecTree(LQNode lQNode, ArrayList<LocalQuery> arrayList, ArrayList<LQNode> arrayList2, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        if (lQNode == null) {
            return null;
        }
        if (arrayList2.contains(lQNode)) {
            Operator operator;
            LQNode lQNode2;
            LQNode lQNode3 = arrayList2.get(arrayList2.indexOf(lQNode));
            LocalQuery localQuery = new LocalQuery(lQNode3.getDatabase(), globalQuery);
            if (lQNode instanceof LQNPNode) {
                localQuery.setSQLQueryString(lQNode.generateSQL());
                ResultSetScan resultSetScan = new ResultSetScan(localQuery, lQNode);
                localQuery.setResultSetScanOp(resultSetScan);
                lQNode3.setOperator(resultSetScan);
                resultSetScan.setSubquery(subQuery);
                resultSetScan.setOutputRelation(lQNode.getOutputRelation());
                arrayList.add(localQuery);
                if (UnityDriver.DEBUG) {
                    System.out.println("\nGenerated a local query: \n" + localQuery.getSQLQueryString());
                }
                return resultSetScan;
            }
            localQuery.setSQLQueryString(Optimizer.buildSQL(lQNode));
            ResultSetScan resultSetScan = subQuery == null || !subQuery.isCorrelated() ? new ResultSetScan(localQuery, lQNode) : new BufferedResultSetScan(localQuery, lQNode);
            for (lQNode2 = lQNode; lQNode2 != null && !(lQNode2 instanceof LQProjNode); lQNode2 = lQNode2.getChild(0)) {
            }
            if (lQNode2 == null) {
                throw new SQLException(UnityDriver.i18n.getString("Optimizer.ErrorQueryGeneration"));
            }
            resultSetScan.setOutputRelation(((LQProjNode)lQNode2).buildOutputRelation(globalQuery));
            resultSetScan.setSubquery(subQuery);
            localQuery.setResultSetScanOp(resultSetScan);
            lQNode.setOutputRelation(resultSetScan.getOutputRelation());
            lQNode3.setOperator(resultSetScan);
            arrayList.add(localQuery);
            if (UnityDriver.DEBUG) {
                System.out.println("\nGenerated a local query: \n" + localQuery.getSQLQueryString());
            }
            if (lQNode instanceof LQSubQueryNode) {
                operator = lQNode.buildOperator(new Operator[]{resultSetScan}, globalQuery, null);
                resultSetScan.setOutputRelation(operator.getOutputRelation());
                lQNode.setOutputRelation(operator.getOutputRelation());
            }
            if (lQNode.getChild(0) instanceof LQSubQueryNode) {
                operator = lQNode.getChild(0).buildOperator(new Operator[]{resultSetScan}, globalQuery, null);
                resultSetScan.setOutputRelation(operator.getOutputRelation());
                lQNode.setOutputRelation(operator.getOutputRelation());
            }
            return resultSetScan;
        }
        Operator[] operatorArray = new Operator[lQNode.getNumChildren()];
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            operatorArray[i] = Optimizer.buildExecTree(lQNode.getChild(i), arrayList, arrayList2, globalQuery, subQuery);
        }
        Operator operator = lQNode.buildOperator(operatorArray, globalQuery, subQuery);
        operator.setSubquery(subQuery);
        return operator;
    }

    public static void processOuterJoin(LQNode lQNode, StringBuffer stringBuffer, ArrayList<Object> arrayList) {
        if (lQNode == null) {
            return;
        }
        Stack<LQNode> stack = new Stack<LQNode>();
        stack.push(lQNode);
        String string = null;
        while (!stack.empty()) {
            LQNode lQNode2 = (LQNode)stack.pop();
            int n = lQNode2.getType();
            if (n != 1) {
                if (n == 2) {
                    string = lQNode2.generateSQL();
                } else {
                    if (n == 207) {
                        stringBuffer.append('(');
                        Optimizer.processOuterJoin(lQNode2.getChild(0), stringBuffer, arrayList);
                        LQJoinNode lQJoinNode = (LQJoinNode)lQNode2;
                        stringBuffer.append(lQJoinNode.generateJoinSQL());
                        Optimizer.processOuterJoin(lQNode2.getChild(1), stringBuffer, arrayList);
                        stringBuffer.append(" ON ");
                        stringBuffer.append(lQNode2.generateSQL());
                        if (string != null) {
                            stringBuffer.append(" AND " + string);
                            string = null;
                        }
                        stringBuffer.append(" )");
                        continue;
                    }
                    if (n == 6 || n == 100) {
                        stringBuffer.append(lQNode2.generateSQL());
                        arrayList.add(lQNode2.getContent());
                    } else if (n == 17) {
                        stringBuffer.append(lQNode2.generateSQL());
                        arrayList.add(lQNode2.getContent());
                        continue;
                    }
                }
            }
            for (int i = 0; i < lQNode2.getNumChildren(); ++i) {
                stack.push(lQNode2.getChild(i));
            }
        }
    }

    public static String buildSQL(LQNode lQNode) {
        Object object;
        int n;
        if (lQNode instanceof LQSubQueryNode) {
            return ((LQSubQueryNode)lQNode).generateSQLNoAlias();
        }
        if (lQNode instanceof LQUnionNode || lQNode instanceof LQIntersectNode || lQNode instanceof LQExceptNode) {
            return Optimizer.buildSQL(lQNode.getChild(0)) + ' ' + lQNode.generateSQL() + ' ' + Optimizer.buildSQL(lQNode.getChild(1));
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        StringBuffer stringBuffer7 = new StringBuffer();
        StringBuffer stringBuffer8 = new StringBuffer();
        StringBuffer stringBuffer9 = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        LQLimitNode lQLimitNode = null;
        LQOrderByNode lQOrderByNode = null;
        int n3 = 0;
        if (lQNode == null) {
            return "";
        }
        Stack<LQNode> stack = new Stack<LQNode>();
        stack.push(lQNode);
        while (!stack.empty()) {
            LQNode lQNode2 = (LQNode)stack.pop();
            int n4 = lQNode2.getType();
            if (n4 == 207) {
                LQJoinNode lQJoinNode = (LQJoinNode)lQNode2;
                if (lQJoinNode.isLeftOuterJoin || lQJoinNode.isRightOuterJoin) {
                    bl = true;
                }
            } else if (n4 == 2) {
                ++n3;
            }
            for (n = 0; n < lQNode2.getNumChildren(); ++n) {
                stack.push(lQNode2.getChild(n));
            }
        }
        stack = new Stack();
        stack.push(lQNode);
        boolean bl3 = false;
        while (!stack.empty()) {
            LQNode lQNode3 = (LQNode)stack.pop();
            n = lQNode3.getType();
            if (n == 1) {
                if (!bl3 || bl2) {
                    String string = lQNode3.generateSQL();
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append("SELECT " + string);
                    }
                    bl2 = false;
                    bl3 = true;
                }
            } else if (n == 16) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("SELECT " + lQNode3.generateSQL() + " ");
                } else {
                    stringBuffer.insert(7, lQNode3.generateSQL() + " ");
                }
            } else if (n == 2) {
                if (!((LQSelNode)lQNode3).bHavingCondition) {
                    String string = lQNode3.generateSQL();
                    if (((LQSelNode)lQNode3).hasOR() && n3 > 1) {
                        string = "(" + string + ")";
                    }
                    if (stringBuffer3.length() == 0) {
                        stringBuffer3.append(" WHERE " + string);
                    } else {
                        stringBuffer3.append(" AND " + string);
                    }
                } else {
                    stringBuffer7.append(" HAVING " + lQNode3.generateSQL());
                }
            } else if (n == 201) {
                if (bl) {
                    Optimizer.processOuterJoin(lQNode3.getChild(0), stringBuffer4, arrayList);
                    stringBuffer4.append(", ");
                    Optimizer.processOuterJoin(lQNode3.getChild(1), stringBuffer4, arrayList);
                    continue;
                }
            } else if (n == 207) {
                if (bl) {
                    Optimizer.processOuterJoin(lQNode3, stringBuffer4, arrayList);
                    continue;
                }
                if (stringBuffer4.length() == 0) {
                    stringBuffer4.append(lQNode3.generateSQL());
                } else {
                    stringBuffer4.append(" AND " + lQNode3.generateSQL());
                }
            } else if (n == 6 || n == 100 || n == 17) {
                if (stringBuffer2.length() == 0) {
                    stringBuffer2.append(" FROM " + lQNode3.generateSQL());
                } else {
                    stringBuffer2.append(", " + lQNode3.generateSQL());
                }
                arrayList.add(lQNode3.getContent());
                if (n == 17) {
                    continue;
                }
            } else if (n == 4) {
                lQOrderByNode = (LQOrderByNode)lQNode3;
                if (stringBuffer5.length() == 0) {
                    stringBuffer5.append(" ORDER BY " + lQNode3.generateSQL());
                } else {
                    stringBuffer5.append(", " + lQNode3.generateSQL());
                }
            } else if (n == 5) {
                if (!((LQGroupByNode)lQNode3).isEmptyGrouping()) {
                    if (stringBuffer6.length() == 0) {
                        stringBuffer6.append(" GROUP BY " + lQNode3.generateSQL());
                    } else {
                        stringBuffer6.append(", " + lQNode3.generateSQL());
                    }
                }
            } else if (n == 18) {
                lQLimitNode = (LQLimitNode)lQNode3;
                String string = lQLimitNode.generateSQL_Limit();
                if (lQLimitNode.getLimitType() == 2) {
                    stringBuffer.append("SELECT " + string + " ");
                    bl2 = true;
                } else if (lQLimitNode.getLimitType() == 3) {
                    n2 = 3;
                    stringBuffer8.append(string);
                    lQLimitNode = (LQLimitNode)lQNode3;
                } else if (lQLimitNode.getLimitType() == 4) {
                    n2 = 4;
                    stringBuffer8.append(string);
                    lQLimitNode = (LQLimitNode)lQNode3;
                } else {
                    stringBuffer8.append(string);
                }
            }
            for (int i = 0; i < lQNode3.getNumChildren(); ++i) {
                stack.push(lQNode3.getChild(i));
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("SELECT ");
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                AnnotatedSourceTable annotatedSourceTable = e instanceof GQTableRef ? ((GQTableRef)e).getTable() : (AnnotatedSourceTable)arrayList.get(i);
                object = annotatedSourceTable.fieldIterator();
                while (object.hasNext()) {
                    AnnotatedSourceField annotatedSourceField = (AnnotatedSourceField)object.next();
                    stringBuffer.append(annotatedSourceField.getColumnName());
                    if (!object.hasNext()) continue;
                    stringBuffer.append(',');
                }
                if (i >= arrayList.size() - 1) continue;
                stringBuffer.append(',');
            }
        }
        if (stringBuffer4.length() > 0) {
            if (bl) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", " + stringBuffer4);
                } else {
                    stringBuffer2.append("FROM " + stringBuffer4);
                }
            } else if (stringBuffer3.length() > 0) {
                stringBuffer3.append(" AND " + stringBuffer4);
            } else {
                stringBuffer3.append("WHERE " + stringBuffer4);
            }
        }
        if (n2 == 0) {
            stringBuffer9.append(stringBuffer + "\n" + stringBuffer2);
            if (stringBuffer3.length() > 0) {
                stringBuffer9.append("\n" + stringBuffer3);
            }
            if (stringBuffer6.length() > 0) {
                stringBuffer9.append("\n" + stringBuffer6);
            }
            if (stringBuffer7.length() > 0) {
                stringBuffer9.append("\n" + stringBuffer7);
            }
            if (stringBuffer5.length() > 0) {
                stringBuffer9.append("\n" + stringBuffer5);
            }
            if (stringBuffer8.length() > 0) {
                stringBuffer9.append("\n" + stringBuffer8);
            }
        } else if (n2 == 3) {
            stringBuffer9.append("SELECT * FROM (SELECT *, ");
            stringBuffer9.append(stringBuffer8.toString() + " OVER (");
            if (stringBuffer5.length() > 0) {
                ArrayList<LQExprNode> arrayList2 = lQOrderByNode.getExprList();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("ORDER BY ");
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object = "_oby" + i;
                    stringBuffer.append(", " + arrayList2.get(i).generateSQL() + " AS " + (String)object);
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append((String)object + " ");
                    stringBuilder.append(lQOrderByNode.getDirection(i));
                }
                stringBuffer9.append((CharSequence)stringBuilder);
            } else {
                stringBuffer9.append("ORDER BY CURRENT_TIMESTAMP");
            }
            stringBuffer9.append(") as rn ");
            stringBuffer9.append("FROM (");
            stringBuffer9.append(stringBuffer);
            stringBuffer9.append("\n" + stringBuffer2);
            if (stringBuffer3.length() > 0) {
                stringBuffer9.append("\n" + stringBuffer3);
            }
            if (stringBuffer6.length() > 0) {
                stringBuffer9.append("\n" + stringBuffer6);
            }
            if (stringBuffer7.length() > 0) {
                stringBuffer9.append("\n" + stringBuffer7);
            }
            stringBuffer9.append(") as R ) R2 ");
            stringBuffer9.append("WHERE rn > " + lQLimitNode.getStart() + " AND rn <= " + (lQLimitNode.getStart() + lQLimitNode.getCount()));
        } else if (n2 == 4) {
            if (lQLimitNode.getStart() > 0) {
                stringBuffer9.append("SELECT *");
                stringBuffer9.append(" FROM (");
                stringBuffer9.append("SELECT R.*");
                stringBuffer9.append(", rownum rn");
                stringBuffer9.append(" FROM (");
                stringBuffer9.append(stringBuffer);
                stringBuffer9.append("\n" + stringBuffer2);
                if (stringBuffer3.length() > 0) {
                    stringBuffer9.append("\n" + stringBuffer3);
                }
                if (stringBuffer6.length() > 0) {
                    stringBuffer9.append("\n" + stringBuffer6);
                }
                if (stringBuffer7.length() > 0) {
                    stringBuffer9.append("\n" + stringBuffer7);
                }
                if (stringBuffer5.length() > 0) {
                    stringBuffer9.append(stringBuffer5);
                }
                stringBuffer9.append(") R) WHERE rn > " + lQLimitNode.getStart() + " AND rn <= " + (lQLimitNode.getStart() + lQLimitNode.getCount()));
            } else {
                stringBuffer9.append("SELECT *");
                stringBuffer9.append(" FROM (");
                stringBuffer9.append(stringBuffer);
                stringBuffer9.append("\n" + stringBuffer2);
                if (stringBuffer3.length() > 0) {
                    stringBuffer9.append("\n" + stringBuffer3);
                }
                if (stringBuffer6.length() > 0) {
                    stringBuffer9.append("\n" + stringBuffer6);
                }
                if (stringBuffer7.length() > 0) {
                    stringBuffer9.append("\n" + stringBuffer7);
                }
                if (stringBuffer5.length() > 0) {
                    stringBuffer9.append(stringBuffer5);
                }
                stringBuffer9.append(") WHERE rownum <= " + lQLimitNode.getCount());
            }
        }
        return stringBuffer9.toString();
    }

    public static void basicOptimization(GlobalQuery globalQuery) throws SQLException {
        Optimizer optimizer = new Optimizer(globalQuery, false, null);
        ArrayList<SubQuery> arrayList = globalQuery.getSubQueries();
        for (int i = 0; i < arrayList.size(); ++i) {
            SubQuery subQuery = arrayList.get(i);
            optimizer.heuristicOptimization(subQuery);
        }
    }
}

