/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.multisource;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.List;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.plugins.multisource.MultiSourcePlugin;

public class MultiRemoveTableAction
extends SquirrelAction {
    private static final long serialVersionUID = 1L;
    private ISession _session;

    public MultiRemoveTableAction(IApplication app, Resources rsrc, ISession session) {
        super(app, (IResources)rsrc);
        this._session = session;
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            SessionInternalFrame sessMainFrm = this._session.getSessionInternalFrame();
            IObjectTreeAPI otree = sessMainFrm.getObjectTreeAPI();
            List tables = otree.getSelectedTables();
            if (tables.size() > 0) {
                ITableInfo ti = (ITableInfo)tables.get(0);
                String sourceName = ti.getSchemaName();
                String tableName = ti.getSimpleName();
                Connection con = this._session.getSQLConnection().getConnection();
                Object gs = MultiSourcePlugin.getSchema(con);
                this.removeTable(sourceName, tableName, gs);
                otree.removeNodes(otree.getSelectedNodes());
                MultiSourcePlugin.updateSession(this._session);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeTable(String sourceName, String tableName, Object gs) {
        Class<?> cls = gs.getClass();
        try {
            Method meth = cls.getMethod("removeTable", String.class, String.class);
            meth.invoke(gs, sourceName, tableName);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

