/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.multisource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.ISQLAliasExt;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.RefreshObjectTreeCommand;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.multisource.MultiAddSourceAction;
import net.sourceforge.squirrel_sql.plugins.multisource.MultiExportAction;
import net.sourceforge.squirrel_sql.plugins.multisource.MultiRemoveSourceAction;
import net.sourceforge.squirrel_sql.plugins.multisource.MultiRemoveTableAction;
import net.sourceforge.squirrel_sql.plugins.multisource.MultiSqlExecutionListener;

public class MultiSourcePlugin
extends DefaultSessionPlugin {
    private PluginResources _resources;
    private static FileWrapper _userSettingsFolder;
    private static boolean isTrial;
    private static final StringManager s_stringMgr;

    static {
        s_stringMgr = StringManagerFactory.getStringManager(MultiSourcePlugin.class);
    }

    public String getInternalName() {
        return "multisource";
    }

    public String getDescriptiveName() {
        return "MultiSource Virtualization Plugin";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getAuthor() {
        return "Ramon Lawrence";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public String getContributors() {
        return "Michael Henderson";
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[0];
    }

    public synchronized void initialize() throws PluginException {
        this._resources = new PluginResources("net.sourceforge.squirrel_sql.plugins.multisource.multisource", (IPlugin)this);
        try {
            _userSettingsFolder = this.getPluginUserSettingsFolder();
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        String dbName = null;
        try {
            if (session != null) {
                dbName = session.getMetaData().getDatabaseProductName().toLowerCase();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (dbName != null && dbName.contains("unity")) {
            IMessageHandler messageHandler = session.getApplication().getMessageHandler();
            MultiSqlExecutionListener sqlExecutionListener = new MultiSqlExecutionListener(messageHandler);
            session.getSessionSheet().getSQLPaneAPI().addSQLExecutionListener((ISQLExecutionListener)sqlExecutionListener);
            if (session.getAlias() != null) {
                isTrial = MultiSourcePlugin.isTrial(session.getSQLConnection().getConnection());
                String url = session.getAlias().getUrl();
                if (url.toLowerCase().indexOf("/virtual") > 0) {
                    Object schema = MultiSourcePlugin.getSchema(session.getSQLConnection().getConnection());
                    String filePath = MultiSourcePlugin.getSourceFilePath(session);
                    File file = new File(filePath);
                    boolean loaded = true;
                    if (schema != null && file.exists()) {
                        try {
                            Method parseSourcesMethod = schema.getClass().getMethod("parseSourcesFile", BufferedReader.class, String.class, Properties.class);
                            String password = session.getAlias().getPassword();
                            Properties info = new Properties();
                            BufferedReader reader = null;
                            if (password != null && password.length() > 0) {
                                info.setProperty("password", password);
                                ClassLoader loader = session.getSQLConnection().getConnection().getClass().getClassLoader();
                                Class<?> fileManagerClass = Class.forName("unity.io.FileManager", true, loader);
                                Method getDecryptedStreamMethod = fileManagerClass.getMethod("getDecryptedStream", String.class, String.class, Properties.class);
                                Properties prop = new Properties();
                                InputStream is = (InputStream)getDecryptedStreamMethod.invoke(null, filePath, password, prop);
                                reader = new BufferedReader(new InputStreamReader(is));
                            } else {
                                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), Charset.forName("UTF-8")));
                            }
                            parseSourcesMethod.invoke(schema, reader, "jdbc:unity://" + filePath, info);
                            new UpdateThread(session).start();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, s_stringMgr.getString("MultiSourcePlugin.loadFailed"));
                            System.out.println(e);
                            loaded = false;
                        }
                    }
                    if (loaded) {
                        this.addTreeNodeMenuActions(session);
                    }
                }
            }
        }
        return new PluginSessionCallbackAdaptor((IPlugin)this);
    }

    private static String getSourceFilePath(ISession session) {
        ISQLAliasExt alias = session.getAlias();
        String aliasId = alias.getIdentifier().toString().replaceAll(":", "_");
        return _userSettingsFolder + File.separator + aliasId + File.separator + alias.getName() + ".xml";
    }

    private void addTreeNodeMenuActions(ISession session) {
        try {
            IObjectTreeAPI otApi = session.getSessionInternalFrame().getObjectTreeAPI();
            IApplication app = session.getApplication();
            otApi.addToPopup(DatabaseObjectType.SESSION, (Action)((Object)new MultiAddSourceAction(app, (Resources)this._resources, session)));
            otApi.addToPopup(DatabaseObjectType.SESSION, (Action)((Object)new MultiExportAction(app, (Resources)this._resources, session)));
            otApi.addToPopup(DatabaseObjectType.SCHEMA, (Action)((Object)new MultiRemoveSourceAction(app, (Resources)this._resources, session)));
            otApi.addToPopup(DatabaseObjectType.TABLE, (Action)((Object)new MultiRemoveTableAction(app, (Resources)this._resources, session)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getSchema(Connection con) {
        Object retobj;
        Class<?> cls = con.getClass();
        try {
            Method meth = cls.getMethod("getGlobalSchema", null);
            retobj = meth.invoke((Object)con, null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return retobj;
    }

    public static boolean isTrial(Connection con) {
        Class<?> cls = con.getClass();
        try {
            Method meth = cls.getMethod("isTrial", null);
            Object retobj = meth.invoke((Object)con, null);
            return (Boolean)retobj;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isTrial() {
        return isTrial;
    }

    public static void updateSession(ISession session) {
        String filePath = MultiSourcePlugin.getSourceFilePath(session);
        MultiSourcePlugin.export(filePath, session);
    }

    public static void refreshTree(ISession session) {
        SessionInternalFrame sessMainFrm = session.getSessionInternalFrame();
        IObjectTreeAPI otree = sessMainFrm.getObjectTreeAPI();
        new RefreshObjectTreeCommand(otree).execute();
    }

    public static void export(String sourcesFileName, ISession session) {
        File f = new File(sourcesFileName);
        String path = "";
        if (f.getParent() != null) {
            path = String.valueOf(f.getParent()) + File.separator;
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdir();
            }
        }
        String sourcesNoExt = sourcesFileName = f.getName();
        int idx = sourcesFileName.indexOf(".xml");
        if (idx > 0) {
            sourcesNoExt = sourcesFileName.substring(0, sourcesFileName.length() - 4);
        }
        Object schema = MultiSourcePlugin.getSchema(session.getSQLConnection().getConnection());
        try {
            String password = session.getAlias().getPassword();
            if (password != null && password.length() < 1) {
                password = null;
            }
            Method getDBsMethod = schema.getClass().getMethod("getAnnotatedDatabases", null);
            ArrayList dbs = (ArrayList)getDBsMethod.invoke(schema, null);
            int i = 0;
            while (i < dbs.size()) {
                Object db = dbs.get(i);
                Method sdExportMethod = db.getClass().getMethod("export", OutputStream.class, String.class);
                Method getDBNameMethod = db.getClass().getMethod("getDatabaseName", null);
                Method setDBSchemaMethod = db.getClass().getMethod("setSchemaFile", String.class);
                String dbName = (String)getDBNameMethod.invoke(db, null);
                String fileName = String.valueOf(sourcesNoExt) + "_" + dbName + ".xml";
                setDBSchemaMethod.invoke(db, fileName);
                FileOutputStream fos = new FileOutputStream(String.valueOf(path) + fileName);
                sdExportMethod.invoke(db, fos, password);
                fos.close();
                ++i;
            }
            Method gsExportMethod = schema.getClass().getMethod("export", OutputStream.class, String.class);
            FileOutputStream fos = new FileOutputStream(String.valueOf(path) + sourcesFileName);
            gsExportMethod.invoke(schema, fos, password);
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class UpdateThread
    extends Thread {
        private ISession session;

        public UpdateThread(ISession session) {
            this.session = session;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.session.getSessionSheet().getObjectTreePanel().refreshTree(true);
        }
    }
}

